/* 
 * Library to remove accents from strings.
 * 
 * http://semplicewebsites.com/removing-accents-javascript
 */
var Latinise = {}; 
Latinise.latin_map = {
	"À":"A", "Á":"A", "Â":"A", "Ã":"A", "Ä":"A", "à":"a", "á´":"a", "â":"a", "ã":"a", "ä":"a",
	"Å":"A", "å":"a",
	"È":"E", "É":"E", "Ê¨":"E", "Ë":"E", "è":"e", "é":"e", "ê":"e", "ë":"e",
	"Ò":"O", "Ó":"O", "Ô":"O", "Õ":"O", "Ö":"O", "ò":"o", "ó":"o", "ô":"o", "õ":"o", "ö":"o",
	"Ù":"U", "Ú":"U", "Û":"U", "Ü":"U", "ù":"u", "ú":"u", "û":"u", "ü":"u",
	"Ý":"Y", "Ÿ":"Y", "ý":"y", "ÿ":"y",
	"Ç":"C", "ç":"c", 
	"Š":"S", "š":"s",
	"Ž":"Z", "ž":"z",
	"Œ":"OE", "œ":"oe", "Æ":"AE", "æ":"ae"
};
String.prototype.latinise = function(){
	return this.replace(/[^A-Za-z0-9\[\] ]/g, function(a){
		return Latinise.latin_map[a] || a
	})
};
String.prototype.latinize = String.prototype.latinise;
String.prototype.isLatin = function(){
	return this == this.latinise()
};