<?php
/**
 * Localized data
 *
 * @copyright Copyright (C) 2010-2024 Combodo SAS
 * @license    https://opensource.org/licenses/AGPL-3.0
 * 
 */
/**
 * @author Vladimir Kunin <v.b.kunin@gmail.com>
 *
 */
Dict::Add('RU RU', 'Russian', 'Русский', [
	'BooleanLabel:no' => 'нет',
	'BooleanLabel:yes' => 'да',
	'Calendar-FirstDayOfWeek' => '1',
	'Class:AuditCategory' => 'Категория аудита',
	'Class:AuditCategory+' => 'Раздел внутри общего аудита',
	'Class:AuditCategory/Attribute:definition_set' => 'Набор объектов',
	'Class:AuditCategory/Attribute:definition_set+' => 'OQL выражение, определяющее набор объектов для проверки',
	'Class:AuditCategory/Attribute:description' => 'Описание категории аудита',
	'Class:AuditCategory/Attribute:description+' => 'Полное описание категории аудита',
	'Class:AuditCategory/Attribute:domains_list' => 'Domains~~',
	'Class:AuditCategory/Attribute:domains_list+' => 'Domains which includes this category~~',
	'Class:AuditCategory/Attribute:name' => 'Название категории',
	'Class:AuditCategory/Attribute:name+' => 'Краткое название для этой категории',
	'Class:AuditCategory/Attribute:ok_error_tolerance' => 'Warning threshold~~',
	'Class:AuditCategory/Attribute:ok_error_tolerance+' => 'Percentage of invalid objects below which the result is a warning (orange)~~',
	'Class:AuditCategory/Attribute:rules_list' => 'Правила аудита',
	'Class:AuditCategory/Attribute:rules_list+' => 'Правила аудита для этой категории',
	'Class:AuditCategory/Attribute:warning_error_tolerance' => 'Error threshold~~',
	'Class:AuditCategory/Attribute:warning_error_tolerance+' => 'Percentage of invalid objects below which the result is in error (red)~~',
	'Class:AuditDomain' => 'Audit Domain~~',
	'Class:AuditDomain+' => 'Audit domains allow to group the audit categories.
Domain usually correspond to who is responsible for checking and fixing errors~~',
	'Class:AuditDomain/Attribute:categories_list' => 'Categories~~',
	'Class:AuditDomain/Attribute:categories_list+' => 'Related audit categories. When running the audit on a domain, all related audit categories are checked and only those.~~',
	'Class:AuditDomain/Attribute:description' => 'Description~~',
	'Class:AuditDomain/Attribute:description+' => '~~',
	'Class:AuditDomain/Attribute:icon' => 'Icon~~',
	'Class:AuditDomain/Attribute:icon+' => '~~',
	'Class:AuditDomain/Attribute:name' => 'Name~~',
	'Class:AuditDomain/Attribute:name+' => 'Its a segmentation of the Audit by who is in charge of fixing it or just interested~~',
	'Class:AuditRule' => 'Правило аудита',
	'Class:AuditRule+' => 'Правило для проверки данной категории аудита',
	'Class:AuditRule/Attribute:category_id' => 'Категория',
	'Class:AuditRule/Attribute:category_id+' => 'Категория для этого правила',
	'Class:AuditRule/Attribute:category_name' => 'Категория',
	'Class:AuditRule/Attribute:category_name+' => 'Категория для этого правила',
	'Class:AuditRule/Attribute:description' => 'Описание правила аудита',
	'Class:AuditRule/Attribute:description+' => 'Полное описание этого правила аудита',
	'Class:AuditRule/Attribute:name' => 'Название правила',
	'Class:AuditRule/Attribute:name+' => 'Краткое название этого правила',
	'Class:AuditRule/Attribute:query' => 'Запрос для выполнения',
	'Class:AuditRule/Attribute:query+' => 'OQL выражение, выполняющее проверку набора объектов категории аудита',
	'Class:AuditRule/Attribute:valid_flag' => 'Валидные объекты?',
	'Class:AuditRule/Attribute:valid_flag+' => 'Выберите \'Истина\', если правило возвращает объекты, успешно прошедшие проверку, иначе выберите \'Ложь\'.',
	'Class:AuditRule/Attribute:valid_flag/Value:false' => 'Ложь',
	'Class:AuditRule/Attribute:valid_flag/Value:false+' => 'Возвращаемые объекты считаются НЕ прошедшими проверку',
	'Class:AuditRule/Attribute:valid_flag/Value:true' => 'Истина',
	'Class:AuditRule/Attribute:valid_flag/Value:true+' => 'Возвращаемые объекты считаются прошедшими проверку',
	'Class:Query' => 'Запрос',
	'Class:Query+' => 'Запрос - это набор данных, определенных динамическим путем',
	'Class:Query/Attribute:description' => 'Описание',
	'Class:Query/Attribute:description+' => 'Длинное описание запроса (назначение, использование и т.д.)',
	'Class:Query/Attribute:export_count' => 'Export counter~~',
	'Class:Query/Attribute:export_count+' => 'Counter reflecting the number of time this query has been executed~~',
	'Class:Query/Attribute:export_last_date' => 'Last export~~',
	'Class:Query/Attribute:export_last_date+' => 'Date and time of the last export execution~~',
	'Class:Query/Attribute:export_last_user_contact' => 'Contact~~',
	'Class:Query/Attribute:export_last_user_contact+' => 'The contact who executed the last export~~',
	'Class:Query/Attribute:export_last_user_id' => 'User~~',
	'Class:Query/Attribute:export_last_user_id+' => 'The user who executed the last export~~',
	'Class:Query/Attribute:is_template' => 'Template for OQL fields~~',
	'Class:Query/Attribute:is_template+' => 'Usable as source for recipient OQL in Notifications~~',
	'Class:Query/Attribute:is_template/Value:no' => 'No~~',
	'Class:Query/Attribute:is_template/Value:yes' => 'Yes~~',
	'Class:Query/Attribute:name' => 'Название',
	'Class:Query/Attribute:name+' => 'Идентифицирует запрос',
	'Class:QueryOQL' => 'OQL запрос',
	'Class:QueryOQL+' => 'Запрос, основанный на OQL (Object Query Language)',
	'Class:QueryOQL/Attribute:fields' => 'Экспорт. поля',
	'Class:QueryOQL/Attribute:fields+' => 'Список атрибутов для экспорта, разделённых запятыми (или alias.attribute)',
	'Class:QueryOQL/Attribute:oql' => 'Выражение',
	'Class:QueryOQL/Attribute:oql+' => 'OQL Выражение',
	'Class:Shortcut' => 'Ссылка',
	'Class:Shortcut+' => '',
	'Class:Shortcut/Attribute:name' => 'Название',
	'Class:Shortcut/Attribute:name+' => 'Используется в меню и заголовке страницы',
	'Class:ShortcutOQL' => 'Search result shortcut~~',
	'Class:ShortcutOQL+' => '',
	'Class:ShortcutOQL/Attribute:auto_reload' => 'Обновлять автоматически',
	'Class:ShortcutOQL/Attribute:auto_reload/Value:custom' => 'Custom rate',
	'Class:ShortcutOQL/Attribute:auto_reload/Value:none' => 'Disabled',
	'Class:ShortcutOQL/Attribute:auto_reload_sec' => 'Интервал обновления (секунды)',
	'Class:ShortcutOQL/Attribute:auto_reload_sec/tip' => 'Минимальное значение %1$d секунд(ы)',
	'Class:ShortcutOQL/Attribute:oql' => 'Запрос',
	'Class:ShortcutOQL/Attribute:oql+' => 'OQL defining the list of objects to search for',
	'Class:TagSetFieldData/Attribute:finalclass' => 'Класс тега',
	'Class:TagSetFieldData/Attribute:obj_attcode' => 'Код поля',
	'Class:TagSetFieldData/Attribute:obj_class' => 'Класс объекта',
	'Class:URP_ActionGrant' => 'действие разрешений',
	'Class:URP_ActionGrant+' => 'разрешения на классы',
	'Class:URP_ActionGrant/Attribute:action' => 'Действие',
	'Class:URP_ActionGrant/Attribute:action+' => 'действие выполняемое на данном классе',
	'Class:URP_ActionGrant/Attribute:class' => 'Класс',
	'Class:URP_ActionGrant/Attribute:class+' => 'Целевой класс',
	'Class:URP_ActionGrant/Attribute:permission' => 'Разрешения',
	'Class:URP_ActionGrant/Attribute:permission+' => 'разрешено или нет?',
	'Class:URP_ActionGrant/Attribute:permission/Value:no' => 'нет',
	'Class:URP_ActionGrant/Attribute:permission/Value:no+' => 'нет',
	'Class:URP_ActionGrant/Attribute:permission/Value:yes' => 'да',
	'Class:URP_ActionGrant/Attribute:permission/Value:yes+' => 'да',
	'Class:URP_ActionGrant/Attribute:profile' => 'Профиль',
	'Class:URP_ActionGrant/Attribute:profile+' => 'использование профиля',
	'Class:URP_ActionGrant/Attribute:profileid' => 'Профиль',
	'Class:URP_ActionGrant/Attribute:profileid+' => 'использование профиля',
	'Class:URP_AttributeGrant' => 'разрешения атрибутов',
	'Class:URP_AttributeGrant+' => 'разрешения на уровне атрибутов',
	'Class:URP_AttributeGrant/Attribute:actiongrantid' => 'Действие предоставления',
	'Class:URP_AttributeGrant/Attribute:actiongrantid+' => 'действие предоставления',
	'Class:URP_AttributeGrant/Attribute:attcode' => 'Атрибут',
	'Class:URP_AttributeGrant/Attribute:attcode+' => 'Код атрибута',
	'Class:URP_ClassProjection' => 'Проекция классов',
	'Class:URP_ClassProjection+' => 'Проекция классов',
	'Class:URP_ClassProjection/Attribute:attribute' => 'Атрибут',
	'Class:URP_ClassProjection/Attribute:attribute+' => 'Целевой атрибут кода (необязательный)',
	'Class:URP_ClassProjection/Attribute:class' => 'Класс',
	'Class:URP_ClassProjection/Attribute:class+' => 'Целевой класс',
	'Class:URP_ClassProjection/Attribute:dimension' => 'Размерность',
	'Class:URP_ClassProjection/Attribute:dimension+' => 'применение размерности',
	'Class:URP_ClassProjection/Attribute:dimensionid' => 'Размерность',
	'Class:URP_ClassProjection/Attribute:dimensionid+' => 'применение размерности',
	'Class:URP_ClassProjection/Attribute:value' => 'Значение выражения',
	'Class:URP_ClassProjection/Attribute:value+' => 'OQL выражение (используя $this) | константа |  | +атрибут кода',
	'Class:URP_Dimensions' => 'размерность',
	'Class:URP_Dimensions+' => 'применение размерности (определение силосов)',
	'Class:URP_Dimensions/Attribute:description' => 'Описание',
	'Class:URP_Dimensions/Attribute:description+' => 'краткое описание',
	'Class:URP_Dimensions/Attribute:name' => 'Название',
	'Class:URP_Dimensions/Attribute:name+' => 'метка',
	'Class:URP_Dimensions/Attribute:type' => 'Тип',
	'Class:URP_Dimensions/Attribute:type+' => 'имя класса или типа данных (проекционный блок)',
	'Class:URP_ProfileProjection' => 'Проекция профиля',
	'Class:URP_ProfileProjection+' => 'Проекция профиля',
	'Class:URP_ProfileProjection/Attribute:attribute' => 'Атрибут',
	'Class:URP_ProfileProjection/Attribute:attribute+' => 'Целевой атрибут кода (необязательный)',
	'Class:URP_ProfileProjection/Attribute:dimension' => 'Размерность',
	'Class:URP_ProfileProjection/Attribute:dimension+' => 'применение размерности',
	'Class:URP_ProfileProjection/Attribute:dimensionid' => 'Размерность',
	'Class:URP_ProfileProjection/Attribute:dimensionid+' => 'применение размерности',
	'Class:URP_ProfileProjection/Attribute:profile' => 'Профиль',
	'Class:URP_ProfileProjection/Attribute:profile+' => 'Название профиля',
	'Class:URP_ProfileProjection/Attribute:profileid' => 'Профиль',
	'Class:URP_ProfileProjection/Attribute:profileid+' => 'использование профиля',
	'Class:URP_ProfileProjection/Attribute:value' => 'Значение выражения',
	'Class:URP_ProfileProjection/Attribute:value+' => 'OQL выражение (используя $user) | константа |  | +атрибут кода',
	'Class:URP_Profiles' => 'Профиль',
	'Class:URP_Profiles+' => 'Пользовательский профиль',
	'Class:URP_Profiles/Attribute:description' => 'Описание',
	'Class:URP_Profiles/Attribute:description+' => 'Описание',
	'Class:URP_Profiles/Attribute:name' => 'Название',
	'Class:URP_Profiles/Attribute:name+' => 'Название',
	'Class:URP_Profiles/Attribute:user_list' => 'Пользователи',
	'Class:URP_Profiles/Attribute:user_list+' => 'Пользователи, имеющие эту роль',
	'Class:URP_StimulusGrant' => 'разрешения стимулов',
	'Class:URP_StimulusGrant+' => 'разрешения на стимулы в жизненном цикле объекта',
	'Class:URP_StimulusGrant/Attribute:class' => 'Класс',
	'Class:URP_StimulusGrant/Attribute:class+' => 'Целевой класс',
	'Class:URP_StimulusGrant/Attribute:permission' => 'Разрешения',
	'Class:URP_StimulusGrant/Attribute:permission+' => 'разрешено или нет?',
	'Class:URP_StimulusGrant/Attribute:permission/Value:no' => 'нет',
	'Class:URP_StimulusGrant/Attribute:permission/Value:no+' => 'нет',
	'Class:URP_StimulusGrant/Attribute:permission/Value:yes' => 'да',
	'Class:URP_StimulusGrant/Attribute:permission/Value:yes+' => 'да',
	'Class:URP_StimulusGrant/Attribute:profile' => 'Профиль',
	'Class:URP_StimulusGrant/Attribute:profile+' => 'использование профиля',
	'Class:URP_StimulusGrant/Attribute:profileid' => 'Профиль',
	'Class:URP_StimulusGrant/Attribute:profileid+' => 'использование профиля',
	'Class:URP_StimulusGrant/Attribute:stimulus' => 'Стимулы',
	'Class:URP_StimulusGrant/Attribute:stimulus+' => 'код стимулов',
	'Class:URP_UserOrg' => 'Организации пользователя',
	'Class:URP_UserOrg+' => 'Разрешённые организации',
	'Class:URP_UserOrg/Attribute:allowed_org_id' => 'Организация',
	'Class:URP_UserOrg/Attribute:allowed_org_id+' => 'Разрешённая организация',
	'Class:URP_UserOrg/Attribute:allowed_org_name' => 'Организация',
	'Class:URP_UserOrg/Attribute:allowed_org_name+' => 'Разрешённая организация',
	'Class:URP_UserOrg/Attribute:reason' => 'Причина',
	'Class:URP_UserOrg/Attribute:reason+' => 'Пояснение причины разрешения доступа к данным этой организации',
	'Class:URP_UserOrg/Attribute:userid' => 'Пользователь',
	'Class:URP_UserOrg/Attribute:userid+' => 'Учетная запись пользователя',
	'Class:URP_UserOrg/Attribute:userlogin' => 'Логин',
	'Class:URP_UserOrg/Attribute:userlogin+' => 'Логин пользователя',
	'Class:URP_UserOrg/Name' => 'Связь между %1$s и %2$s',
	'Class:URP_UserProfile' => 'Профиль пользователя',
	'Class:URP_UserProfile+' => 'Профиль пользователя',
	'Class:URP_UserProfile/Attribute:profile' => 'Профиль',
	'Class:URP_UserProfile/Attribute:profile+' => 'Название профиля',
	'Class:URP_UserProfile/Attribute:profileid' => 'Профиль',
	'Class:URP_UserProfile/Attribute:profileid+' => 'использование профиля',
	'Class:URP_UserProfile/Attribute:reason' => 'Причина',
	'Class:URP_UserProfile/Attribute:reason+' => 'Пояснение причины назначения этой роли',
	'Class:URP_UserProfile/Attribute:userid' => 'Пользователь',
	'Class:URP_UserProfile/Attribute:userid+' => 'учетная запись пользователя',
	'Class:URP_UserProfile/Attribute:userlogin' => 'Логин',
	'Class:URP_UserProfile/Attribute:userlogin+' => 'Логин пользователя',
	'Class:URP_UserProfile/Name' => 'Связь между %1$s и %2$s',
	'Class:User' => 'Пользователь',
	'Class:User+' => 'Пользователь',
	'Class:User/Attribute:allowed_org_list' => 'Разрешённые организации',
	'Class:User/Attribute:allowed_org_list+' => 'Пользователь может видеть данные только указанных ниже организации. Оставьте поле пустым для доступа ко всем данным.',
	'Class:User/Attribute:contactid' => 'Персона',
	'Class:User/Attribute:contactid+' => '',
	'Class:User/Attribute:email' => 'Email',
	'Class:User/Attribute:email+' => 'Адрес электронной почты связанной персоны',
	'Class:User/Attribute:finalclass' => 'Тип аккаунта',
	'Class:User/Attribute:finalclass+' => '',
	'Class:User/Attribute:first_name' => 'Имя',
	'Class:User/Attribute:first_name+' => 'Имя связанной персоны',
	'Class:User/Attribute:language' => 'Язык',
	'Class:User/Attribute:language+' => 'Язык пользователя',
	'Class:User/Attribute:language/Value:EN US' => 'Английский',
	'Class:User/Attribute:language/Value:EN US+' => 'Английский (США)',
	'Class:User/Attribute:language/Value:FR FR' => 'Французский',
	'Class:User/Attribute:language/Value:FR FR+' => 'Французский (Франция)',
	'Class:User/Attribute:last_name' => 'Фамилия',
	'Class:User/Attribute:last_name+' => 'Фамилия связанной персоны',
	'Class:User/Attribute:login' => 'Логин',
	'Class:User/Attribute:login+' => 'Уникальный логин пользователя',
	'Class:User/Attribute:org_id' => 'Организация',
	'Class:User/Attribute:org_id+' => 'Организация связанной персоны',
	'Class:User/Attribute:profile_list' => 'Профили',
	'Class:User/Attribute:profile_list+' => 'Профили, предоставляющие права этому пользователю',
	'Class:User/Attribute:status' => 'Статус',
	'Class:User/Attribute:status+' => 'Учетная запись пользователя включена или отключена.',
	'Class:User/Attribute:status/Value:disabled' => 'Отключен',
	'Class:User/Attribute:status/Value:enabled' => 'Включен',
	'Class:User/Error:AllowedOrgsMustContainUserOrg' => 'Allowed organizations must contain User organization~~',
	'Class:User/Error:AtLeastOneOrganizationIsNeeded' => 'Этому пользователю должна быть назначена хотя бы одна организация.',
	'Class:User/Error:AtLeastOneProfileIsNeeded' => 'Как минимум один профиль должен быть назначен данному пользователю.',
	'Class:User/Error:CurrentProfilesHaveInsufficientRights' => 'The current list of profiles does not give sufficient access rights (Users are not modifiable anymore)~~',
	'Class:User/Error:LoginMustBeUnique' => 'Логин должен быть уникальным - "%1s" уже используется.',
	'Class:User/Error:OrganizationNotAllowed' => 'Организация не разрешена.',
	'Class:User/Error:PersonIsMandatory' => 'Необходимо выбрать персону.',
	'Class:User/Error:PortalPowerUserHasInsufficientRights' => 'The Portal power user profile does not give sufficient access rights (another profile must be added)~~',
	'Class:User/Error:ProfileNotAllowed' => 'Profile "%1$s" cannot be added it will deny the access to backoffice~~',
	'Class:User/Error:StatusChangeIsNotAllowed' => 'Changing status is not allowed for your own User~~',
	'Class:User/Error:UserOrganizationNotAllowed' => 'Учетная запись пользователя не принадлежит вашим разрешенным организациям.',
	'Class:User/Warning:NoContactHasImpact' => 'Cautious: there is no Person defined on this User, this prevents access to portals, news notifications and other side effects in back-office~~',
	'Class:User/Warning:NoOrganizationMeansFullAccess' => 'No "Allowed Organizations" defined for this user, this means they have access to all organizations~~',
	'Class:UserDashboard' => 'Дашборд пользователя',
	'Class:UserDashboard+' => '~~',
	'Class:UserDashboard/Attribute:contents' => 'Содержимое',
	'Class:UserDashboard/Attribute:contents+' => '',
	'Class:UserDashboard/Attribute:menu_code' => 'Код меню',
	'Class:UserDashboard/Attribute:menu_code+' => '',
	'Class:UserDashboard/Attribute:user_id' => 'Пользователь',
	'Class:UserDashboard/Attribute:user_id+' => '',
	'Class:UserInternal' => 'Внутренний пользователь',
	'Class:UserInternal+' => 'Учетная запись создана внутри '.ITOP_APPLICATION_SHORT,
	'Class:lnkAuditCategoryToAuditDomain' => 'Link AuditCategory / AuditDomain~~',
	'Class:lnkAuditCategoryToAuditDomain+' => '~~',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:category_id' => 'Category~~',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:category_id+' => 'Audit Category~~',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:category_name' => 'Category name~~',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:category_name+' => 'Audit category name~~',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:domain_id' => 'Domain~~',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:domain_id+' => 'Audit domain~~',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:domain_name' => 'Domain name~~',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:domain_name+' => 'Audit domain name~~',
	'DayOfWeek-Friday' => 'Пятница',
	'DayOfWeek-Friday-Min' => 'Пт',
	'DayOfWeek-Monday' => 'Понедельник',
	'DayOfWeek-Monday-Min' => 'Пн',
	'DayOfWeek-Saturday' => 'Суббота',
	'DayOfWeek-Saturday-Min' => 'Сб',
	'DayOfWeek-Sunday' => 'Воскресенье',
	'DayOfWeek-Sunday-Min' => 'Вс',
	'DayOfWeek-Thursday' => 'Четверг',
	'DayOfWeek-Thursday-Min' => 'Чт',
	'DayOfWeek-Tuesday' => 'Вторник',
	'DayOfWeek-Tuesday-Min' => 'Вт',
	'DayOfWeek-Wednesday' => 'Среда',
	'DayOfWeek-Wednesday-Min' => 'Ср',
	'Enum:Undefined' => 'Не определён',
	'ExcelExport:AutoDownload' => 'Начать загрузку файла автоматически по готовности',
	'ExcelExport:PreparingExport' => 'Подготовка к экспорту...',
	'ExcelExport:Statistics' => 'Статистика',
	'ExcelExporter:BuildingExcelFile' => 'Формирование файла Excel...',
	'ExcelExporter:Done' => 'Готово',
	'ExcelExporter:DownloadButton' => 'Загрузить %1$s',
	'ExcelExporter:ExportButton' => 'Экспорт',
	'ExcelExporter:ExportDialogTitle' => 'Экспорт в Excel',
	'ExcelExporter:ExportMenu' => 'Экспорт в Excel...',
	'ExcelExporter:RetrievingData' => 'Извлечение данных...',
	'Expression:Operator:=' => ': ~~',
	'Expression:Operator:AND' => ' AND ',
	'Expression:Operator:OR' => ' OR ',
	'Expression:Unit:Long:DAY' => 'day(s)',
	'Expression:Unit:Long:HOUR' => 'hour(s)',
	'Expression:Unit:Long:MINUTE' => 'minute(s)',
	'Expression:Unit:Short:DAY' => 'd',
	'Expression:Unit:Short:MONTH' => 'm',
	'Expression:Unit:Short:WEEK' => 'w',
	'Expression:Unit:Short:YEAR' => 'y',
	'Expression:Verb:ISNULL' => ': undefined~~',
	'Expression:Verb:NOW' => 'now',
	'Menu:AdminTools' => 'Инструменты администратора',
	'Menu:AdminTools+' => 'Инструменты администратора',
	'Menu:AdminTools?' => 'Инструменты доступны только для пользователей c правами администратора',
	'Menu:AuditCategories' => 'Категории аудита',
	'Menu:AuditCategories+' => 'Категории аудита',
	'Menu:AuditCategories:Title' => 'Audit configuration~~',
	'Menu:CSVImportMenu' => 'Импорт CSV',
	'Menu:CSVImportMenu+' => 'Пакетное создание или обновление',
	'Menu:ConfigurationTools' => 'Конфигурация',
	'Menu:DataAdministration' => 'Администрирование данных',
	'Menu:DataAdministration+' => 'Администрирование данных',
	'Menu:DataModelMenu' => 'Модель данных',
	'Menu:DataModelMenu+' => 'Обзор модели данных',
	'Menu:DataSources' => 'Синхронизация данных',
	'Menu:DataSources+' => 'Синхронизация данных',
	'Menu:ExportMenu' => 'Экспорт',
	'Menu:ExportMenu+' => 'Экспорт результатов любого запроса в HTML, CSV или XML',
	'Menu:MyShortcuts' => 'Избранное',
	'Menu:Notifications:Title' => 'Категории аудита',
	'Menu:NotificationsMenu' => 'Уведомления',
	'Menu:NotificationsMenu+' => 'Настройка уведомлений',
	'Menu:ProfilesMenu' => 'Профили',
	'Menu:ProfilesMenu+' => 'Профили пользователей',
	'Menu:ProfilesMenu:Title' => 'Профили пользователей',
	'Menu:Queries' => 'Запросы OQL',
	'Menu:QueryMenu' => 'Книга запросов',
	'Menu:QueryMenu+' => 'Книга запросов',
	'Menu:RunQueriesMenu' => 'Выполнение запросов',
	'Menu:RunQueriesMenu+' => 'Выполнение любых запросов',
	'Menu:SystemTools' => 'Система',
	'Menu:TagAdminMenu' => 'Теги',
	'Menu:TagAdminMenu+' => 'Теги',
	'Menu:UniversalSearchMenu' => 'Универсальный поиск',
	'Menu:UniversalSearchMenu+' => 'Поиск чего угодно...',
	'Menu:UserAccountsMenu' => 'Учетные записи',
	'Menu:UserAccountsMenu+' => 'Учетные записи пользователей',
	'Menu:UserAccountsMenu:Title' => 'Учетные записи пользователей',
	'Menu:UserManagement' => 'Управление пользователями',
	'Menu:UserManagementMenu' => 'Управление пользователями',
	'Menu:UserManagementMenu+' => 'Управление пользователями',
	'Menu:WelcomeMenu' => 'Добро пожаловать',
	'Menu:WelcomeMenu+' => 'Добро пожаловать в '.ITOP_APPLICATION_SHORT,
	'Menu:WelcomeMenuPage' => 'Добро пожаловать',
	'Menu:WelcomeMenuPage+' => 'Добро пожаловать в '.ITOP_APPLICATION_SHORT,
	'Month-01' => 'Январь',
	'Month-01-Short' => 'Янв.',
	'Month-02' => 'Февраль',
	'Month-02-Short' => 'Фев.',
	'Month-03' => 'Март',
	'Month-03-Short' => 'Мар.',
	'Month-04' => 'Апрель',
	'Month-04-Short' => 'Апр.',
	'Month-05' => 'Май',
	'Month-05-Short' => 'Май',
	'Month-06' => 'Июнь',
	'Month-06-Short' => 'Июн.',
	'Month-07' => 'Июль',
	'Month-07-Short' => 'Июл.',
	'Month-08' => 'Август',
	'Month-08-Short' => 'Авг.',
	'Month-09' => 'Сентябрь',
	'Month-09-Short' => 'Сен.',
	'Month-10' => 'Октябрь',
	'Month-10-Short' => 'Окт.',
	'Month-11' => 'Ноябрь',
	'Month-11-Short' => 'Ноя.',
	'Month-12' => 'Декабрь',
	'Month-12-Short' => 'Дек.',
	'ObjectRef:Archived' => 'Архивный',
	'ObjectRef:Obsolete' => 'Устаревший',
	'Portal:AddAttachment' => 'Добавить вложения',
	'Portal:Attachment_No_To_Ticket_Name' => 'Вложение #%1$d to %2$s (%3$s)',
	'Portal:Attachments' => 'Вложения',
	'Portal:Back' => 'Назад',
	'Portal:Button:CloseTicket' => 'Закрыть запрос',
	'Portal:Button:ReopenTicket' => 'Вновь открыть запрос',
	'Portal:Button:UpdateRequest' => 'Обновить запрос',
	'Portal:ChangeMyPassword' => 'Изменить пароль',
	'Portal:ClosedRequests' => 'Мои закрытые запросы',
	'Portal:CreateNewIncidentItil' => 'Создать новый инцидент',
	'Portal:CreateNewRequest' => 'Создать новый запрос',
	'Portal:CreateNewRequestItil' => 'Создать новый запрос',
	'Portal:DescriptionOfTheRequest' => 'Введите описание запроса:',
	'Portal:Disconnect' => 'Выйти',
	'Portal:EnterYourCommentsOnTicket' => 'Введите ваши комментарии по решению этого запроса:',
	'Portal:ErrorNoContactForThisUser' => 'Ошибка: текущий пользователь не ассоциирован с Контактом/Персоной. Пожалуйста, свяжитесь с вашим администратором.',
	'Portal:NoClosedRequest' => 'Нет запросов в этой категории',
	'Portal:NoOpenRequest' => 'Нет запросов в этой категории.',
	'Portal:NoRequestMgmt' => 'Уважаемый %1$s, вы были перенаправлены на портал, потому что ваш аккаунт содержит профиль \'Portal user\'. К сожалению, '.ITOP_APPLICATION_SHORT.' не содержит модуля \'Request Management\'. Пожалуйста, свяжитесь с вашим администратором.',
	'Portal:OpenRequests' => 'Мои открытые запросы',
	'Portal:PleaseSelectAServiceSubCategory' => 'Пожалуйста, выберите подкатегорию услуги для создания запроса',
	'Portal:PleaseSelectOneService' => 'Пожалуйста, выберите услугу для создания запроса',
	'Portal:Refresh' => 'Обновить',
	'Portal:RemoveAttachment' => ' Удалить вложения',
	'Portal:ResolvedRequests' => 'Мои решённые запросы',
	'Portal:SelectRequestTemplate' => 'Select a template for %1$s~~',
	'Portal:SelectService' => 'Выберите услугу из каталога:',
	'Portal:SelectSubcategoryFrom_Service' => 'Выберите подкатегорию услуги %1$s:',
	'Portal:ShowClosed' => 'Показать закрытые запросы',
	'Portal:ShowOngoing' => 'Показать открытые запросы',
	'Portal:Title' => 'Пользовательский портал '.ITOP_APPLICATION_SHORT,
	'Portal:TitleDetailsFor_Request' => 'Подробности запроса',
	'Portal:TitleRequestDetailsFor_Request' => 'Подробности запроса %1$s:',
	'Portal:WelcomeUserOrg' => 'Добро пожаловать, %1$s (%2$s)',
	'Query:baseinfo' => 'General information~~',
	'Query:exportInfo' => 'Export information~~',
	'Tag:Archived' => 'Архивный',
	'Tag:Archived+' => 'Доступен только в режиме архива',
	'Tag:Obsolete' => 'Устаревший',
	'Tag:Obsolete+' => 'Исключается из результатов поиска и анализа влияния',
	'Tag:Synchronized' => 'Синхронизированный',
	'UI-ChangeManagementMenu-ChangesByStatus' => 'Изменения по статусу',
	'UI-ChangeManagementMenu-ChangesByType' => 'Изменения по типу',
	'UI-ChangeManagementMenu-ChangesNotYetAssigned' => 'Изменения, ожидающие назначения',
	'UI-ChangeManagementOverview-ChangeByType' => 'Изменения по типу',
	'UI-ChangeManagementOverview-ChangeUnassigned' => 'Изменения, не назначенные агентам',
	'UI-ChangeManagementOverview-ChangeWithOutage' => 'Перерывы в обслуживании, связанные с изменениями',
	'UI-ConfigMgmtMenuOverview-FunctionalCIByType' => 'Элементы конфигурации по типу',
	'UI-ConfigMgmtMenuOverview-FunctionalCIbyStatus' => 'Элементы конфигурации по статусу',
	'UI-ConfigurationManagementMenu-InfraByStatus' => 'Объекты инфраструктуры по статусу',
	'UI-ConfigurationManagementMenu-InfraByType' => 'Объекты инфраструктуры по типу',
	'UI-ContactsMenu-ContactsByLocation' => 'Договоры по размещению',
	'UI-ContactsMenu-ContactsByStatus' => 'Договоры по статусу',
	'UI-ContactsMenu-ContactsByType' => 'Договоры по типу',
	'UI-IncidentManagementOverview-IncidentByPriority' => 'Инциденты по приоритетам',
	'UI-IncidentManagementOverview-IncidentByService' => 'Инциденты по услугам',
	'UI-IncidentManagementOverview-IncidentUnassigned' => 'Инциденты, не назначенные агентам',
	'UI-RequestManagementOverview-RequestByPriority' => 'Запросы по приоритетам',
	'UI-RequestManagementOverview-RequestByService' => 'Запросы по услугам',
	'UI-RequestManagementOverview-RequestUnassigned' => 'Запросы, не назначенные агентам',
	'UI-ServiceManagementOverview-CustomerContractToRenew' => 'Договоры с заказчиками, которые должны быть продлены в течение 30 дней',
	'UI-ServiceManagementOverview-ProviderContractToRenew' => 'Договоры с поставщиками, которые должны быть продлены в течение 30 дней',
	'UI:About:DataModel' => 'Модель данных',
	'UI:About:Extension_Version' => 'Версия: %1$s',
	'UI:About:InstallationOptions' => 'Параметр установки',
	'UI:About:Licenses' => 'Лицензии',
	'UI:About:ManualExtensionSource' => 'Расширение',
	'UI:About:RemoteExtensionSource' => 'Data~~',
	'UI:About:Support' => 'Информация для технической поддержки',
	'UI:About:Title' => 'Об этом '.ITOP_APPLICATION_SHORT,
	'UI:AboutBox' => 'Об этом '.ITOP_APPLICATION_SHORT.'...',
	'UI:AccessRO-All' => 'Только чтение',
	'UI:AccessRO-Users' => 'Только чтение для конечных пользователей',
	'UI:ActionNotAllowed' => 'You are not allowed to perform this action on these objects.~~',
	'UI:AddAnExisting_Class' => 'Добавить объекты класса %1$s...',
	'UI:AddLinkedObjectsOf_Class' => 'Добавить объект %1$s',
	'UI:AddObjectsOf_Class_LinkedWith_Class' => 'Добавление объектов %1$s для связи с объектом %2$s',
	'UI:AddObjectsOf_Class_LinkedWith_Class_Instance' => 'Добавить %1$s объекты связанные с %2$s: %3$s',
	'UI:AllOrganizations' => ' Все организации ',
	'UI:ApplicationEnvironment' => 'Application environment: %1$s~~',
	'UI:Apply_Stimulus_On_Object_In_State_ToTarget_State' => 'Применение %1$s на объект: %2$s в состоянии %3$s для целевого класса: %4$s.',
	'UI:ArchiveMode:Banner' => 'Archive mode~~',
	'UI:ArchiveMode:Banner+' => 'Archived objects are visible, and no modification is allowed~~',
	'UI:ArchiveModeOff' => 'Deactivate archive mode~~',
	'UI:ArchiveModeOn' => 'Activate archive mode~~',
	'UI:Archive_User_OnBehalfOf_User' => '%1$s от имени %2$s',
	'UI:AttemptingToChangeASlaveAttribute_Name' => 'The field %1$s is not writable because it is mastered by the data synchronization. Value remains unchanged.~~',
	'UI:AttemptingToSetAReadOnlyAttribute_Name' => 'Attempting to set the read-only field: %1$s~~',
	'UI:AttemptingToSetASlaveAttribute_Name' => 'The field %1$s (%2$s) is not writable because it is mastered by the data synchronization. Value not set.~~',
	'UI:Audit:AuditCategory:Subtitle' => '%1$s errors ouf of %2$s - %3$s%% of the object are valid~~',
	'UI:Audit:AuditErrors' => 'Audit Errors~~',
	'UI:Audit:Dashboard:ObjectsAudited' => 'Objects audited~~',
	'UI:Audit:Dashboard:ObjectsInError' => 'Objects in errors~~',
	'UI:Audit:Dashboard:ObjectsValidated' => 'Objects validated~~',
	'UI:Audit:Error:ValueNA' => 'n/a~~',
	'UI:Audit:ErrorIn_Category' => 'Error in Category~~',
	'UI:Audit:ErrorIn_Category_Reason' => 'OQL ошибка в категории %1$s: %2$s.',
	'UI:Audit:ErrorIn_Rule' => 'Error in Rule~~',
	'UI:Audit:ErrorIn_Rule_Reason' => 'OQL ошибка в правиле %1$s: %2$s.',
	'UI:Audit:HeaderAuditRule' => 'Правило аудита',
	'UI:Audit:HeaderNbErrors' => '# Ошибки',
	'UI:Audit:HeaderNbObjects' => '# Объекты',
	'UI:Audit:Interactive:All:BreadCrumb' => 'Full audit~~',
	'UI:Audit:Interactive:All:BreadCrumb+' => 'Audit results for all rules~~',
	'UI:Audit:Interactive:All:SubTitle' => 'Full audit: includes all rules, all categories, all domains~~',
	'UI:Audit:Interactive:All:Title' => 'Audit results~~',
	'UI:Audit:Interactive:Button:Back' => 'Back to the audit~~',
	'UI:Audit:Interactive:Button:Configuration' => 'Audit configuration~~',
	'UI:Audit:Interactive:Categories:BreadCrumb' => 'Categories~~',
	'UI:Audit:Interactive:Categories:BreadCrumb+' => 'Audit categories: %1$s~~',
	'UI:Audit:Interactive:Categories:SubTitle' => 'Audit results for all the rules belonging to one of those %1$s categories~~',
	'UI:Audit:Interactive:Categories:Title' => 'Audit results for categories: %1$s~~',
	'UI:Audit:Interactive:Domain:BreadCrumb' => '%1$s~~',
	'UI:Audit:Interactive:Domain:BreadCrumb+' => 'Audit for Domain: %1$s~~',
	'UI:Audit:Interactive:Domain:SubTitle' => 'Audit results for all the rules belonging to a category related to the domain: %1$s~~',
	'UI:Audit:Interactive:Domain:Title' => 'Audit results for Domain: %1$s~~',
	'UI:Audit:Interactive:Selection:BadgeAll' => 'All categories~~',
	'UI:Audit:Interactive:Selection:BreadCrumb' => 'Selection~~',
	'UI:Audit:Interactive:Selection:BreadCrumb+' => 'Selection of an Audit to run~~',
	'UI:Audit:Interactive:Selection:SubTitle' => 'Select a domain to get the results limited to this domain or select "All categories" to get a full audit (can take time or even fail if too much data to audit)~~',
	'UI:Audit:Interactive:Selection:Title' => 'Selection of an audit~~',
	'UI:Audit:InteractiveAudit' => 'Интерактивный аудит',
	'UI:Audit:OqlError' => 'OQL Error~~',
	'UI:Audit:PercentageOk' => '% Ok',
	'UI:Audit:Title' => ITOP_APPLICATION_SHORT.' - Аудит CMDB',
	'UI:Audit:ViewRules' => 'Check the rules~~',
	'UI:AutoApplyConfirmationMessage' => 'Некоторые изменения не вступили в силу. Применить их немедленно?',
	'UI:AvailableInlineImagesLegend' => 'Доступные изображения',
	'UI:BeforeAdding_Class_ObjectsSaveThisObject' => 'Сохраните текущий объект перед добавлением новых элементов класса %1$s. ',
	'UI:BrowseInlineImages' => 'Обзор...',
	'UI:BulkAction:NoObjectSelected' => 'Please select at least one object to perform this operation~~',
	'UI:BulkDeletePageTitle' => ITOP_APPLICATION_SHORT.' - Пакетное удаление',
	'UI:BulkDeleteTitle' => 'Выбор объектов для удаления:',
	'UI:BulkModify:N_MoreValues' => '%1$d дополнительных значения...',
	'UI:BulkModify:Value_Exists_N_Times' => '%1$s, %2$d раз(а)',
	'UI:BulkModifyErrors' => 'Ошибки (если есть)',
	'UI:BulkModifyErrors+' => 'Ошибки, препятствующие изменению',
	'UI:BulkModifyStatus' => 'Операция',
	'UI:BulkModifyStatus+' => 'Статус операции',
	'UI:BulkModifyStatusError' => 'Ошибка',
	'UI:BulkModifyStatusModified' => 'Изменен',
	'UI:BulkModifyStatusOk' => 'Ok',
	'UI:BulkModifyStatusSkipped' => 'Пропущен',
	'UI:BulkModify_Count_DistinctValues' => '%1$d различных значения:',
	'UI:Button:Add' => ' Добавить ',
	'UI:Button:AddObject' => ' Добавить... ',
	'UI:Button:AddToList' => ' << Добавить ',
	'UI:Button:Apply' => 'Применить',
	'UI:Button:Back' => ' << Назад ',
	'UI:Button:BrowseObjects' => ' Обзор... ',
	'UI:Button:Cancel' => 'Отмена',
	'UI:Button:ChangePassword' => ' Изменить пароль ',
	'UI:Button:Clear' => 'Очистить',
	'UI:Button:Close' => 'Закрыть',
	'UI:Button:Confirm' => ' Confirm ~~',
	'UI:Button:Create' => ' Создать ',
	'UI:Button:Delete' => ' Удалить ',
	'UI:Button:DoImport' => ' Выполнить импорт ! ',
	'UI:Button:Done' => ' Готово ',
	'UI:Button:Evaluate' => ' Оценка ',
	'UI:Button:Evaluate:Title' => ' Оценка (Ctrl+Enter)',
	'UI:Button:Export' => 'Экспорт',
	'UI:Button:FilterList' => ' Фильтр... ',
	'UI:Button:Finish' => ' Завершить ',
	'UI:Button:GlobalSearch' => 'Поиск',
	'UI:Button:GoPrint' => 'Печать...',
	'UI:Button:Insert' => 'Вставить',
	'UI:Button:Less' => 'Меньше',
	'UI:Button:Login' => 'Войти',
	'UI:Button:Logoff' => 'Выход',
	'UI:Button:ModifyAll' => 'Редактировать все',
	'UI:Button:More' => 'Ещё',
	'UI:Button:MoveDown' => 'Вниз',
	'UI:Button:MoveUp' => 'Вверх',
	'UI:Button:Next' => ' Вперёд >> ',
	'UI:Button:Ok' => 'Ok',
	'UI:Button:PreviewModifications' => 'Предпросмотр изменений >>',
	'UI:Button:Query' => ' Запрос ',
	'UI:Button:Refresh' => 'Обновить',
	'UI:Button:Remove' => 'Удалить',
	'UI:Button:RemoveDocument' => 'Удалить документ',
	'UI:Button:RemoveFromList' => ' Удалить >> ',
	'UI:Button:RemoveImage' => 'Удалить изображение',
	'UI:Button:Rename' => ' Переименовать...',
	'UI:Button:ResetImage' => 'Восстановить предыдущее изображение',
	'UI:Button:ResetPassword' => ' Сбросить пароль ',
	'UI:Button:Restart' => ' |<< Перезапустить ',
	'UI:Button:Save' => 'Сохранить',
	'UI:Button:SaveAnd' => 'Save and %1$s~~',
	'UI:Button:Search' => 'Поиск',
	'UI:Button:SearchInHierarchy' => 'Поиск в иерархии',
	'UI:Button:Send' => 'Отправить',
	'UI:Button:SendAnd' => 'Отправить и %1$s',
	'UI:Button:SimulateImport' => ' Эмулировать импорт ',
	'UI:Button:Test' => 'Тестировать!',
	'UI:Button:UploadImage' => 'Загрузить изображение с компьютера',
	'UI:Button:Wait' => 'Подождите, пока обновятся поля',
	'UI:CSVExport:AdvancedMode' => 'Расширенный режим',
	'UI:CSVExport:AdvancedMode+' => 'In advanced mode, several columns are added to the export: the id of the object, the id of external keys and their reconciliation attributes.',
	'UI:CSVExport:LostChars' => 'Проблема кодировки',
	'UI:CSVExport:LostChars+' => 'The downloaded file will be encoded into %1$s. '.ITOP_APPLICATION_SHORT.' has detected some characters that are not compatible with this format. Those characters will either be replaced by a substitute (e.g. accentuated chars losing the accent), or they will be discarded. You can copy/paste the data from your web browser. Alternatively, you can contact your administrator to change the encoding (See parameter \'csv_file_default_charset\').',
	'UI:CSVImport:AdvancedMode' => 'Расширенный режим',
	'UI:CSVImport:AdvancedMode+' => 'In advanced mode the "id" (primary key) of the objects can be used to update and rename objects. However the column "id" (if present) can only be used as a search criteria and can not be combined with any other search criteria.',
	'UI:CSVImport:AlertIncompleteMapping' => 'Пожалуйста, выберите сопоставление для каждого поля.',
	'UI:CSVImport:AlertMultipleMapping' => 'Пожалуйста, убедитесь, что целевое поле сопоставляется только один раз.',
	'UI:CSVImport:AlertNoSearchCriteria' => 'Пожалуйста, выберите хотя бы один критерий поиска.',
	'UI:CSVImport:CSVDataPreview' => 'Предпросмотр данных CSV',
	'UI:CSVImport:ClassesSelectOne' => '-- выберите значение --',
	'UI:CSVImport:Column' => 'Column %1$s~~',
	'UI:CSVImport:CommentsAndHeader' => 'Комментарии и заголовок',
	'UI:CSVImport:CustomDateTimeFormat' => 'Пользовательский формат: %1$s',
	'UI:CSVImport:CustomDateTimeFormatTooltip' => 'Available placeholders:<table>
<tr><td>Y</td><td>year (4 digits, e.g. 2016)</td></tr>
<tr><td>y</td><td>year (2 digits, e.g. 16 for 2016)</td></tr>
<tr><td>m</td><td>month (2 digits, e.g. 01..12)</td></tr>
<tr><td>n</td><td>month (1 or 2 digits no leading zero, e.g. 1..12)</td></tr>
<tr><td>d</td><td>day (2 digits, e.g. 01..31)</td></tr>
<tr><td>j</td><td>day (1 or 2 digits no leading zero, e.g. 1..31)</td></tr>
<tr><td>H</td><td>hour (24 hour, 2 digits, e.g. 00..23)</td></tr>
<tr><td>h</td><td>hour (12 hour, 2 digits, e.g. 01..12)</td></tr>
<tr><td>G</td><td>hour (24 hour, 1 or 2 digits no leading zero, e.g. 0..23)</td></tr>
<tr><td>g</td><td>hour (12 hour, 1 or 2 digits no leading zero, e.g. 1..12)</td></tr>
<tr><td>a</td><td>hour, am or pm (lowercase)</td></tr>
<tr><td>A</td><td>hour, AM or PM (uppercase)</td></tr>
<tr><td>i</td><td>minutes (2 digits, e.g. 00..59)</td></tr>
<tr><td>s</td><td>seconds (2 digits, e.g. 00..59)</td></tr>
</table>',
	'UI:CSVImport:DataLine1' => 'Строка данных 1',
	'UI:CSVImport:DataLine2' => 'Строка данных 2',
	'UI:CSVImport:DateAndTimeFormats' => 'Формат даты и времени',
	'UI:CSVImport:DefaultDateTimeFormat_Format_Example' => 'Формат по умолчанию: %1$s (например, %2$s)',
	'UI:CSVImport:Encoding' => 'Кодировка символов',
	'UI:CSVImport:ErrorExtendedAttCode' => 'Внутренняя ошибка: "%1$s" некорректный код потому, что "%2$s" НЕ является внешним ключом класса "%3$s"',
	'UI:CSVImport:ErrorOnlyOneColumn' => 'Ошибка: данные содержат только один столбец (выбран правильный разделитель?).',
	'UI:CSVImport:FieldName' => 'Поле %1$d',
	'UI:CSVImport:HeaderFields' => 'Поля',
	'UI:CSVImport:HeaderMappings' => 'Сопоставление',
	'UI:CSVImport:HeaderSearch' => 'Поиск?',
	'UI:CSVImport:LinesNotImported' => 'Строки не были загружены:',
	'UI:CSVImport:LinesNotImported+' => 'Следующие строки не были импортированы, потому что они содержат ошибки',
	'UI:CSVImport:MappingNotApplicable' => '-- игнорировать это поле --',
	'UI:CSVImport:MappingSelectOne' => '-- выберите значение --',
	'UI:CSVImport:NoData' => 'Пустой набор данных..., пожалуйста введите что-нибудь!',
	'UI:CSVImport:ObjectsHadErrors' => '%1$d объект(ов) содержат ошибки.',
	'UI:CSVImport:ObjectsRemainedUnchanged' => '%1$d objects(s) remained unchanged.~~',
	'UI:CSVImport:ObjectsReчmainedUnchanged' => '%1$d объект(ов) не изменились.',
	'UI:CSVImport:ObjectsWereAdded' => '%1$d объект(ов) добавлены.',
	'UI:CSVImport:ObjectsWereModified' => '%1$d объект(ов) изменены.',
	'UI:CSVImport:ObjectsWillBeAdded' => '%1$d объект(ов) будут добавлены.',
	'UI:CSVImport:ObjectsWillBeModified' => '%1$d объект(ов) будут изменены.',
	'UI:CSVImport:ObjectsWillHaveErrors' => '%1$d объект(ов) будут содержать ошибки.',
	'UI:CSVImport:ObjectsWillStayUnchanged' => '%1$d объект(ов) останутся неизменными.',
	'UI:CSVImport:PasteData' => 'Вставить данные для импорта:',
	'UI:CSVImport:PickClassForTemplate' => 'Выбор шаблона для загрузки: ',
	'UI:CSVImport:QualifierDoubleQuote+' => '" (двойная кавычка)',
	'UI:CSVImport:QualifierOther' => 'другое:',
	'UI:CSVImport:QualifierSimpleQuote+' => '\' (одинарная кавычка)',
	'UI:CSVImport:SelectAClassFirst' => 'Выберите класс импортируемых объектов для настройки распределения полей',
	'UI:CSVImport:SelectClass' => 'Выберите класс:',
	'UI:CSVImport:SelectFile' => 'Выбор файла для импорта:',
	'UI:CSVImport:SeparatorCharacter' => 'Символ разделителя:',
	'UI:CSVImport:SeparatorComma+' => ', (запятая)',
	'UI:CSVImport:SeparatorOther' => 'другое:',
	'UI:CSVImport:SeparatorSemicolon+' => '; (точка с запятой)',
	'UI:CSVImport:SeparatorTab+' => 'Tab (табуляция)',
	'UI:CSVImport:Skip_N_LinesAtTheBeginning' => 'Пропустить %1$s строк(у) от начала файла',
	'UI:CSVImport:Tab:CopyPaste' => 'Копировать и вставить данные',
	'UI:CSVImport:Tab:LoadFromFile' => 'Загрузить из файла',
	'UI:CSVImport:Tab:Templates' => 'Шаблоны',
	'UI:CSVImport:TextQualifierCharacter' => 'Символ экранирования текста',
	'UI:CSVImport:TreatFirstLineAsHeader' => 'Использовать первую строку как заголовок (названия столбцов)',
	'UI:CSVImport:ViewAllAmbiguousValues' => 'View all ambiguous values~~',
	'UI:CSVImport:ViewAllPossibleValues' => 'View all possible values~~',
	'UI:CSVImport:idField' => 'id (Первичный ключ)',
	'UI:CSVImportConfirmMessage' => 'Are you sure you want to do this?',
	'UI:CSVImportConfirmTitle' => 'Please confirm the operation',
	'UI:CSVImportCreated_items' => 'Created: %1$d',
	'UI:CSVImportError_items' => 'Errors: %1$d',
	'UI:CSVImportModified_items' => 'Modified: %1$d',
	'UI:CSVImportUnchanged_items' => 'Unchanged: %1$d',
	'UI:CSVReport-Icon-Created' => 'Создан',
	'UI:CSVReport-Icon-Error' => 'Ошибка',
	'UI:CSVReport-Icon-Missing' => 'Упущен.',
	'UI:CSVReport-Icon-Modified' => 'Измен.',
	'UI:CSVReport-Icon-Unchanged' => 'Неизмен.',
	'UI:CSVReport-Object-Ambiguous' => 'Неоднознач.: %1$s',
	'UI:CSVReport-Object-Created' => 'Объект создан',
	'UI:CSVReport-Object-Error' => 'ОШИБКА: %1$s',
	'UI:CSVReport-Object-MissingToUpdate' => 'Отсутствующий объект: будет обновлен',
	'UI:CSVReport-Object-MissingUpdated' => 'Отсутствующий объект: обновлен',
	'UI:CSVReport-Object-ToCreate' => 'Объект будет создан',
	'UI:CSVReport-Row-Created' => 'созданный',
	'UI:CSVReport-Row-Disappeared' => 'disappeared, changed %1$d cols~~',
	'UI:CSVReport-Row-Issue' => 'Ошибка: %1$s',
	'UI:CSVReport-Row-Issue-Ambiguous' => 'Неоднозначное сопоставление',
	'UI:CSVReport-Row-Issue-Attribute' => 'Неизвестное значение(я) атрибута',
	'UI:CSVReport-Row-Issue-DateFormat' => 'Формат даты неверен',
	'UI:CSVReport-Row-Issue-ExpectedDateFormat' => 'Expected format: %1$s~~',
	'UI:CSVReport-Row-Issue-Inconsistent' => 'Несоответствие атрибутов: %1$s',
	'UI:CSVReport-Row-Issue-Internal' => 'Внутренняя ошибка: %1$s, %2$s',
	'UI:CSVReport-Row-Issue-MissingExtKey' => 'Не может быть создан так как отсутствует внешний ключ(и): %1$s',
	'UI:CSVReport-Row-Issue-Reconciliation' => 'Невозможно согласовать',
	'UI:CSVReport-Row-Unchanged' => 'без изменений',
	'UI:CSVReport-Row-Updated' => 'updated %1$d cols~~',
	'UI:CSVReport-Stats-Created' => '%1$.0f %% загруженных объектов были созданы.',
	'UI:CSVReport-Stats-Errors' => '%1$.0f %% загруженных объектов имеют ошибки. Проигнорированы.',
	'UI:CSVReport-Stats-Modified' => '%1$.0f %% загруженных объектов были изменены.',
	'UI:CSVReport-Value-Ambiguous' => 'Неоднозначное сопоставление: найдено %1$s объектов',
	'UI:CSVReport-Value-ChangeIssue' => '\'%1$s\' is an invalid value~~',
	'UI:CSVReport-Value-Issue-AllowedValues' => 'Allowed \'%1$s\' value(s): %2$s~~',
	'UI:CSVReport-Value-Issue-Format' => 'Не удалось обработать запрос: %1$s',
	'UI:CSVReport-Value-Issue-FoundMany' => 'Найдено %1$d значений',
	'UI:CSVReport-Value-Issue-NoMatch' => 'Неизвестное значение атрибута \'%1$s\': ничего не найдено, проверьте правильность ввода',
	'UI:CSVReport-Value-Issue-NotFound' => 'Не найден',
	'UI:CSVReport-Value-Issue-Null' => 'Поле не должно быть пустым',
	'UI:CSVReport-Value-Issue-Readonly' => 'Аттрибут \'%1$s\' доступен только для чтения и не может быть изменен (ткущее значение: %2$s, предложенное значение: %3$s)',
	'UI:CSVReport-Value-Issue-Unknown' => 'Неизвестное значение атрибута \'%1$s\': %2$s',
	'UI:CSVReport-Value-Missing' => 'Отсутствует обязательное значение',
	'UI:CSVReport-Value-Modified' => 'Изменен',
	'UI:CSVReport-Value-NoMatch' => 'No match for value \'%1$s\'~~',
	'UI:CSVReport-Value-NoMatch-NoObject' => 'There are no \'%1$s\' objects~~',
	'UI:CSVReport-Value-NoMatch-NoObject-ForCurrentUser' => 'There are no \'%1$s\' objects found with your current profile~~',
	'UI:CSVReport-Value-NoMatch-PossibleValues' => 'Some possible \'%1$s\' value(s): %2$s~~',
	'UI:CSVReport-Value-NoMatch-SomeObjectNotVisibleForCurrentUser' => 'There are some \'%1$s\' objects not visible with your current profile~~',
	'UI:CSVReport-Value-SetIssue' => 'Invalid value for attribute~~',
	'UI:CancelConfirmationMessage' => 'Настройки НЕ будут сохранены. Продолжить?',
	'UI:CaseLog:Header_Date_UserName' => '%1$s - %2$s:~~',
	'UI:CaseLog:InitialValue' => 'Initial value:~~',
	'UI:CaseLogTypeYourTextHere' => 'Введите свой текст:',
	'UI:ChangeManagementMenu' => 'Управление изменениями',
	'UI:ChangeManagementMenu+' => 'Управление изменениями',
	'UI:ChangeManagementMenu:Title' => 'Обзор изменений',
	'UI:ChangeMgmtMenuOverview:Title' => 'Панель управления изменениями',
	'UI:ChangePwdMenu' => 'Изменить пароль...',
	'UI:ChangesLogTitle' => 'Журнал изменений (%1$d):',
	'UI:Class_Object_NotUpdated' => 'Изменений не обнаружено, %1$s (%2$s) <strong>не</strong> был изменён.',
	'UI:Class_Object_Updated' => '%1$s (%2$s) обновлён.',
	'UI:ClickToCreateNew' => 'Создать: %1$s',
	'UI:ClonePageTitle_Object_Class' => ITOP_APPLICATION_SHORT.' - Клон %1$s - %2$s модификация',
	'UI:CloneTitle_Class_Object' => 'Клон %1$s: <span class=\"hilite\">%2$s</span>',
	'UI:CollapseList' => 'Свернуть',
	'UI:ColumnsAndSortOrder' => 'Колонки и порядок сортировки:',
	'UI:Combo:SelectValue' => '--- выбор значения ---',
	'UI:ConcurrentLockKilled' => 'Блокировка для предотвращения изменений текущего объекта снята.',
	'UI:ConfigMgmtMenuOverview:Title' => 'Панель управления конфигурациями',
	'UI:ConfigurationManagementMenu' => 'Управление конфигурациями',
	'UI:ConfigurationManagementMenu+' => 'Управление конфигурациями',
	'UI:ConfigurationManagementMenu:Title' => 'Обзор инфраструктуры',
	'UI:ConfigureThisList' => 'Настроить список...',
	'UI:ContactsMenu' => 'Договоры',
	'UI:ContactsMenu+' => 'Договоры',
	'UI:ContactsMenu:Title' => 'Обзор договоров',
	'UI:CountOfObjects' => '%1$d объектов соответствует критериям.',
	'UI:CountOfResults' => '%1$d объект(ы)',
	'UI:Create_Class_InState' => 'Create the %1$s in state: ~~',
	'UI:CreationPageTitle_Class' => ITOP_APPLICATION_SHORT.' - Создание объекта %1$s',
	'UI:CreationTitle_Class' => 'Создание объекта %1$s',
	'UI:CurrentObjectIsLockedBy_User' => 'Объект заблокирован, поскольку в настоящее время редактируется пользователем %1$s.',
	'UI:CurrentObjectIsLockedBy_User_Explanation' => 'Объект в настоящее время редактируется пользователем %1$s. Ваши изменения не будут сохранены, поскольку они могут быть перезаписаны.',
	'UI:CurrentObjectIsSoftLockedBy_User' => 'The object is currently being modified by %1$s. You\'ll be able to submit your modifications once they have finished.~~',
	'UI:CurrentObjectLockExpired' => 'Срок блокировки для предотвращения одновременного изменения объекта истек.',
	'UI:CurrentObjectLockExpired_Explanation' => 'Срок блокировки для предотвращения одновременного изменения объекта истек. Вы больше не можете сохранить свои изменения, поскольку другим пользователям теперь разрешено изменять данный объект.',
	'UI:Dashboard:Actions' => 'Действия дашборда',
	'UI:Dashboard:CreateCustom' => 'Создать пользовательскую версию...',
	'UI:Dashboard:DeleteCustom' => 'Удалить пользовательскую версию...',
	'UI:Dashboard:Edit' => 'Редактировать дашборд...',
	'UI:Dashboard:EditCustom' => 'Редактировать пользовательскую версию...',
	'UI:Dashboard:NotUpToDateUntilContainerSaved' => 'This dashboard displays information that does not include the on-going changes.~~',
	'UI:Dashboard:Revert' => 'Вернуть стандартную версию...',
	'UI:Dashboard:RevertConfirm' => 'Будет возвращена стандартная версия дашборда. Все изменения будут утеряны. Хотите продолжить?',
	'UI:DashboardEdit:Apply' => 'Apply~~',
	'UI:DashboardEdit:AutoReload' => 'Обновлять автоматически',
	'UI:DashboardEdit:AutoReloadSec' => 'Интервал обновления (секунды)',
	'UI:DashboardEdit:AutoReloadSec+' => 'Минимальный интервал %1$d секунд',
	'UI:DashboardEdit:DashboardTitle' => 'Заголовок',
	'UI:DashboardEdit:DashletProperties' => 'Свойства дашлета',
	'UI:DashboardEdit:Dashlets' => 'Доступные дашлеты',
	'UI:DashboardEdit:Layout' => 'Макет',
	'UI:DashboardEdit:Properties' => 'Свойства дашборда',
	'UI:DashboardEdit:Revert' => 'Revert~~',
	'UI:DashboardEdit:Title' => 'Редактор дашборда',
	'UI:DashletBadge:Description' => 'Иконка объекта с возможностью создания и поиска',
	'UI:DashletBadge:Label' => 'Значок',
	'UI:DashletBadge:Prop-Class' => 'Класс',
	'UI:DashletCreation:Dashboard' => 'Добавить на дашборд',
	'UI:DashletCreation:DashletType' => 'Тип дашлета',
	'UI:DashletCreation:EditNow' => 'Перейти в редактор дашборда',
	'UI:DashletCreation:Title' => 'Создать новый дашлет',
	'UI:DashletGroupBy:MissingGroupBy' => 'Пожалуйста, выберите поле по которому объекты будут сгруппированы',
	'UI:DashletGroupBy:Order:asc' => 'По возрастанию',
	'UI:DashletGroupBy:Order:desc' => 'По убыванию',
	'UI:DashletGroupBy:Prop-Function' => 'Функция агрегирования',
	'UI:DashletGroupBy:Prop-FunctionAttribute' => 'Атрибут функции',
	'UI:DashletGroupBy:Prop-GroupBy' => 'Группировка',
	'UI:DashletGroupBy:Prop-GroupBy:DayOfMonth' => 'Day of month for %1$s~~',
	'UI:DashletGroupBy:Prop-GroupBy:DayOfWeek' => 'Day of week for %1$s~~',
	'UI:DashletGroupBy:Prop-GroupBy:Hour' => 'Hour of %1$s (0-23)~~',
	'UI:DashletGroupBy:Prop-GroupBy:Month' => 'Month of %1$s (1 - 12)~~',
	'UI:DashletGroupBy:Prop-GroupBy:Select-DayOfMonth' => '%1$s (day of month)~~',
	'UI:DashletGroupBy:Prop-GroupBy:Select-DayOfWeek' => '%1$s (day of week)~~',
	'UI:DashletGroupBy:Prop-GroupBy:Select-Hour' => '%1$s (hour)~~',
	'UI:DashletGroupBy:Prop-GroupBy:Select-Month' => '%1$s (month)~~',
	'UI:DashletGroupBy:Prop-Limit' => 'Лимит',
	'UI:DashletGroupBy:Prop-OrderDirection' => 'Направление',
	'UI:DashletGroupBy:Prop-OrderField' => 'Сортировать по',
	'UI:DashletGroupBy:Prop-Query' => 'Запрос',
	'UI:DashletGroupBy:Prop-Style' => 'Стиль',
	'UI:DashletGroupBy:Prop-Title' => 'Заголовок',
	'UI:DashletGroupByBars:Description' => 'Столбчатая диаграмма',
	'UI:DashletGroupByBars:Label' => 'Столбчатая диаграмма',
	'UI:DashletGroupByPie:Description' => 'Круговая диаграмма',
	'UI:DashletGroupByPie:Label' => 'Круговая диаграмма',
	'UI:DashletGroupByTable:Description' => 'Список (сгруппированный по полю)',
	'UI:DashletGroupByTable:Label' => 'Группировка (таблица)',
	'UI:DashletHeaderDynamic:Description' => 'Заголовок со статистикой (группировать по ...)',
	'UI:DashletHeaderDynamic:Label' => 'Заголовок со статистикой',
	'UI:DashletHeaderDynamic:Prop-GroupBy' => 'Группировать по',
	'UI:DashletHeaderDynamic:Prop-Icon' => 'Иконка',
	'UI:DashletHeaderDynamic:Prop-Query' => 'Запрос',
	'UI:DashletHeaderDynamic:Prop-Subtitle' => 'Подзаголовок',
	'UI:DashletHeaderDynamic:Prop-Subtitle:Default' => 'Контакты',
	'UI:DashletHeaderDynamic:Prop-Title' => 'Заголовок',
	'UI:DashletHeaderDynamic:Prop-Title:Default' => 'Контакты',
	'UI:DashletHeaderDynamic:Prop-Values' => 'Значения',
	'UI:DashletHeaderStatic:Description' => 'Displays an horizontal separator~~',
	'UI:DashletHeaderStatic:Label' => 'Заголовок',
	'UI:DashletHeaderStatic:Prop-Icon' => 'Иконка',
	'UI:DashletHeaderStatic:Prop-Title' => 'Заголовок',
	'UI:DashletHeaderStatic:Prop-Title:Default' => 'Контакты',
	'UI:DashletObjectList:Description' => 'Список объектов',
	'UI:DashletObjectList:Label' => 'Список объектов',
	'UI:DashletObjectList:Prop-Menu' => 'Меню',
	'UI:DashletObjectList:Prop-Query' => 'Запрос',
	'UI:DashletObjectList:Prop-Title' => 'Заголовок',
	'UI:DashletPlainText:Description' => 'Текст (без форматирования)',
	'UI:DashletPlainText:Label' => 'Текст',
	'UI:DashletPlainText:Prop-Text' => 'Текст',
	'UI:DashletPlainText:Prop-Text:Default' => 'Введите текст...',
	'UI:DashletProxy:Description' => 'Proxy dashlet~~',
	'UI:DashletProxy:Label' => 'Proxy~~',
	'UI:DashletProxy:Prop-XMLConfiguration' => 'Configuration (shown as raw XML)~~',
	'UI:DashletProxy:RenderNoDataText:Edit' => 'No preview available for this third-party dashlet (class "%1$s").~~',
	'UI:DashletUnknown:Description' => 'Unknown dashlet (might have been uninstalled)~~',
	'UI:DashletUnknown:Label' => 'Unknown~~',
	'UI:DashletUnknown:Prop-XMLConfiguration' => 'Configuration (shown as raw XML)~~',
	'UI:DashletUnknown:RenderNoDataText:Edit' => 'No preview available for this dashlet (class "%1$s").~~',
	'UI:DashletUnknown:RenderText:Edit' => 'Unable to render this dashlet (class "%1$s"). Check with your administrator if it is still available.~~',
	'UI:DashletUnknown:RenderText:View' => 'Unable to render this dashlet.~~',
	'UI:DeadlineMissedBy_duration' => 'Пропущен %1$s',
	'UI:Deadline_Days_Hours_Minutes' => '%1$d д %2$d ч %3$d мин',
	'UI:Deadline_Hours_Minutes' => '%1$d ч %2$d мин',
	'UI:Deadline_LessThan1Min' => '< 1 мин',
	'UI:Deadline_Minutes' => '%1$d мин',
	'UI:Delect:Confirm_Count_ObjectsOf_Class' => 'Подтвердите удаление %1$d объектов класса %2$s.',
	'UI:Delect:Confirm_Object' => 'Подтвердите удаление %1$s.',
	'UI:Delete:AutomaticResetOf_Fields' => 'автоматически сброшено поле(я): %1$s',
	'UI:Delete:AutomaticallyDeleted' => 'автоматически удалён',
	'UI:Delete:CannotDeleteBecause' => 'Could not be deleted: %1$s~~',
	'UI:Delete:CannotUpdateBecause_Issue' => 'Должно быть автоматически обновлено, но: %1$s',
	'UI:Delete:CleaningUpRefencesTo_Object' => 'Удаление всех ссылок на %1$s...',
	'UI:Delete:CleaningUpRefencesTo_Several_ObjectsOf_Class' => 'Удаление всех ссылок на %1$d объектов класса %2$s...',
	'UI:Delete:ConfirmDeletionOf_Count_ObjectsOf_Class' => 'Удаление %1$d объектов класса %2$s',
	'UI:Delete:ConfirmDeletionOf_Name' => 'Удаление %1$s',
	'UI:Delete:Consequence+' => 'Влияние',
	'UI:Delete:Count_Objects/LinksReferencingTheObjects' => '%1$d объектов/связей ссылаются на удаляемые объекты.',
	'UI:Delete:Count_Objects/LinksReferencing_Object' => '%1$d объектов/связей ссылаются на %2$s.',
	'UI:Delete:Deleted' => 'удален',
	'UI:Delete:Done+' => 'Что было сделано...',
	'UI:Delete:MustBeDeletedManually' => 'Необходимо удалить вручную',
	'UI:Delete:MustBeDeletedManuallyButNotPossible' => 'Must be deleted manually, but this is not feasible: %1$s~~',
	'UI:Delete:NotAllowedToDelete' => 'Вы не можете удалить этот объект',
	'UI:Delete:NotAllowedToUpdate_Fields' => 'Вы не можете обновить следующее(ие) поле(я): %1$s',
	'UI:Delete:PleaseDoTheManualOperations' => 'Необходимо выполнить указанные операции в ручную до удаления этого объекта',
	'UI:Delete:ReferencesMustBeDeletedToEnsureIntegrity' => 'Для обеспечения целостности базы данных необходимо очистить все ссылки на удаляемые объекты.',
	'UI:Delete:ShouldBeDeletedAtomaticallyButNotPossible' => 'Should be automatically deleted, but this is not feasible: %1$s~~',
	'UI:Delete:SorryDeletionNotAllowed' => 'К сожалению, вы не можете удалить этот объект, см. подробное объяснение выше',
	'UI:Delete:WillAutomaticallyUpdate_Fields' => 'Будет обновлено автоматически (сброс: %1$s)',
	'UI:Delete:WillBeDeletedAutomatically' => 'Будет удалено автоматически',
	'UI:Delete:_Name_Class_Deleted' => '%1$s - %2$s удалено.',
	'UI:Details+' => 'Подробности',
	'UI:DetailsPageTitle' => ITOP_APPLICATION_SHORT.' - %1$s - %2$s подробности',
	'UI:DisconnectedDlgMessage' => 'Вы вышли из системы. Выполните повторный вход для продолжения работы.',
	'UI:DisconnectedDlgTitle' => 'Внимание!',
	'UI:DisplayAll' => 'Показать всё',
	'UI:DisplayThisMessageAtStartup' => 'Показать это сообщение при запуске',
	'UI:Display_X_ItemsPerPage_prefix' => 'Показывать',
	'UI:Display_X_ItemsPerPage_suffix' => 'элементов на странице',
	'UI:Document:NoPreview' => 'Предпросмотр документов данного типа недоступен',
	'UI:Document:OpenInNewWindow:Download' => 'Открыть в новом окне: %1$s, Загрузка: %2$s',
	'UI:Download-CSV' => 'Загрузка %1$s',
	'UI:DownloadDocument_' => 'Скачать',
	'UI:DurationForm_Days_Hours_Minutes_Seconds' => '%1$s д %2$s ч %3$s мин %4$s с',
	'UI:Edit:SearchQuery' => 'Select a predefined query~~',
	'UI:Edit:TestQuery' => 'Проверить запрос',
	'UI:ElementsDisplayed' => 'Фильтр',
	'UI:EmptyChangesLogTitle' => 'Журнал изменений пустой',
	'UI:Error:1ParametersMissing' => 'Ошибка: следующий параметр должен быть указан для этой операции: %1$s.',
	'UI:Error:2ParametersMissing' => 'Ошибка: следующие параметры должен быть указан для этой операции: %1$s и %2$s.',
	'UI:Error:3ParametersMissing' => 'Ошибка: следующие параметры должен быть указан для этой операции: %1$s, %2$s и %3$s.',
	'UI:Error:4ParametersMissing' => 'Ошибка: следующие параметры должен быть указан для этой операции: %1$s, %2$s, %3$s и %4$s.',
	'UI:Error:ActionNotAllowed' => 'У вас недостаточно прав для выполнения это действия',
	'UI:Error:AnErrorOccuredWhileRunningTheQuery_Message' => 'Ошибка при выполнении запроса: %1$s',
	'UI:Error:BulkDeleteNotAllowedOn_Class' => 'Вам не разрешено выполнять массовое удаления объектов класса %1$s',
	'UI:Error:BulkModifyNotAllowedOn_Class' => 'Вам не разрешено выполнять массовое обновление объектов класса %1$s',
	'UI:Error:CannotDeleteBecause' => 'Не удалось удалить этот объект: %1$s',
	'UI:Error:CannotDeleteBecauseManualOpNeeded' => 'Не удалось удалить этот объект, поскольку перед удалением необходимо выполнить некоторые операции вручную.',
	'UI:Error:CannotDeleteBecauseOfDepencies' => 'Не удалось удалить этот объект, поскольку перед удалением необходимо выполнить некоторые операции вручную (в отношении зависимостей от объекта).',
	'UI:Error:CannotWriteToTmp_Dir' => ' Невозможно записать временный файл на диск. upload_tmp_dir = "%1$s".',
	'UI:Error:DeleteNotAllowedOn_Class' => 'Вы не можете удалять объекты класса %1$s',
	'UI:Error:IncorrectLinkDefinition_LinkedClass_Class' => 'Неправильное определение ссылки: класс объектов для управления: %1$s не был найден в качестве внешнего ключа в классе %2$s',
	'UI:Error:IncorrectOQLQuery_Message' => 'Ошибка: некорректный запрос OQL: %1$s',
	'UI:Error:InvalidDashboard' => 'Ошибка: недопустимый дашборд',
	'UI:Error:InvalidDashboardFile' => 'Ошибка: недопустимый файл дашборда',
	'UI:Error:InvalidGroupByFields' => 'Неверный список полей для группировки: "%1$s".',
	'UI:Error:InvalidToken' => 'Error: the requested operation has already been performed (CSRF token not found)~~',
	'UI:Error:Invalid_Stimulus_On_Object_In_State' => 'Ошибка: недействительный стимул "%1$s" на объекте %2$s в состоянии "%3$s".',
	'UI:Error:MaintenanceMode' => 'Приложение в режиме технического обслуживания',
	'UI:Error:MaintenanceTitle' => 'Техническое обслуживание',
	'UI:Error:MandatoryTemplateParameter_group_by' => 'Параметр group_by является обязательным. Проверьте определение отображения шаблона.',
	'UI:Error:MandatoryTemplateParameter_object_id' => 'Параметр object_id является обязательным если указан link_attr. Проверьте определение отображения шаблона.',
	'UI:Error:MandatoryTemplateParameter_target_attr' => 'Параметр target_attr является обязательным если указан link_attr. Проверьте определение отображения шаблона',
	'UI:Error:NoTmpDir' => 'Временный каталог не определен.',
	'UI:Error:NotEnoughRightsToDelete' => 'Не удалось удалить этот объект, так как текущий пользователь не обладает необходимыми правами.',
	'UI:Error:ObjectAlreadyCloned' => 'Ошибка: объект уже клонирован!',
	'UI:Error:ObjectAlreadyCreated' => 'Ошибка: объект уже создан!',
	'UI:Error:ObjectAlreadyUpdated' => 'Ошибка: объект уже обновлён.',
	'UI:Error:ObjectCannotBeUpdated' => 'Ошибка: объект не может быть обновлён.',
	'UI:Error:Object_Class_Id_NotFound' => 'Объект: %1$s:%2$d не найден.',
	'UI:Error:ObjectsAlreadyDeleted' => 'Ошибка: объект уже удалён!',
	'UI:Error:ReadNotAllowedOn_Class' => 'You are not allowed to view objects of class %1$s~~',
	'UI:Error:SMTP:UnknownVendor' => 'OAuth SMTP provider %1$s does not exist  (email_transport_smtp.oauth.provider)~~',
	'UI:Error:SaveFailed' => 'Не удаётся сохранить объект:',
	'UI:Error:UnsupportedStyleOfBlock' => 'Ошибка: неподдерживаемый стиль блока: "%1$s".',
	'UI:Error:UploadFailedUnknownCause_Code' => 'Загрузка файла не удалась по неизвестной причине. (Код ошибки = "%1$s").',
	'UI:Error:UploadStoppedByExtension_FileName' => 'Загрузка остановлена по расширению. (Имя файла = "%1$s").',
	'UI:Error:UploadedFileTooBig' => 'Загружаемый файл слишком большой – максимально разрешённый размер %1$s. Проверьте параметры upload_max_filesize и post_max_size в настройках PHP.',
	'UI:Error:UploadedFileTruncated.' => 'Загруженный файл был усечен !',
	'UI:Error:WizardCircularReferenceInDependencies' => 'Ошибка: Циклическая ссылка в зависимостях между полями, проверить модель данных.',
	'UI:ErrorPageTitle' => ITOP_APPLICATION_SHORT.' - Ошибка',
	'UI:Error_Details' => 'Ошибка: %1$s.',
	'UI:ExplainPrintable' => 'Щелкните значок %1$s, чтобы скрыть элементы от печати.<br/>Используйте функцию "печать" вашего браузера для предварительного просмотра перед печатью.<br/>Примечание: этот заголовок и другие элементы управления не будут напечатаны.',
	'UI:ExportDashBoard' => 'Экспорт',
	'UI:ExtField_AsRemoteField' => '%1$s (%2$s)~~',
	'UI:ExtKey_AsFriendlyName' => '%1$s (Friendly Name)~~',
	'UI:ExtKey_AsLink' => '%1$s (Link)~~',
	'UI:FailedToApplyStimuli' => 'Операция не может быть выполнена.',
	'UI:FatalErrorMessage' => 'Критическая ошибка, '.ITOP_APPLICATION_SHORT.' не может продолжать работу.',
	'UI:FavoriteLanguage' => 'Язык',
	'UI:FavoriteOrganizations' => 'Избранные организации',
	'UI:FavoriteOrganizations+' => 'Отметьте в списке ниже организации, которые вы хотите видеть в раскрывающемся списке бокового меню для быстрого доступа. Обратите внимание, что это не параметр безопасности, объекты из любой организации по-прежнему видны и могут быть доступны, выбрав "Все организации" в раскрывающемся списке.',
	'UI:FavoriteOtherSettings' => 'Другие настройки',
	'UI:Favorites:Default_X_ItemsPerPage' => 'Длина списков по умолчанию: %1$s элементов на страницу',
	'UI:Favorites:SelectYourLanguage' => 'Выберите Ваш язык',
	'UI:Favorites:ShowObsoleteData' => 'Показывать устаревшие данные',
	'UI:Favorites:ShowObsoleteData+' => 'Отображение устаревших данных в результатах поиска и списках элементов для выбора',
	'UI:FillAllMandatoryFields' => 'Пожалуйста, заполните все обязательные поля.',
	'UI:ForAllLists' => 'Для всех списков',
	'UI:Form:Property' => 'Свойство',
	'UI:Form:Value' => 'Значение',
	'UI:FullTextSearchTitle_Text' => 'Результаты для "%1$s":',
	'UI:GroupBy:Count' => 'Количество',
	'UI:GroupBy:Count+' => 'Количество элементов',
	'UI:GroupBy:avg' => 'Среднее',
	'UI:GroupBy:avg+' => 'Average of %1$s',
	'UI:GroupBy:count' => 'Количество',
	'UI:GroupBy:count+' => 'Число элементов',
	'UI:GroupBy:max' => 'Максимум',
	'UI:GroupBy:max+' => 'Maximum of %1$s',
	'UI:GroupBy:min' => 'Минимум',
	'UI:GroupBy:min+' => 'Minimum of %1$s',
	'UI:GroupBy:sum' => 'Сумма',
	'UI:GroupBy:sum+' => 'Sum of %1$s',
	'UI:Help' => 'Помощь',
	'UI:HierarchyOf_Class' => 'Иерархия по: %1$s',
	'UI:History:BulkImportDetails' => 'Changes resulting from the CSV import performed on %1$s (by %2$s)~~',
	'UI:History:BulkImports' => 'История',
	'UI:History:BulkImports+' => 'List of CSV imports (latest import first)',
	'UI:History:Changes' => 'Изменения',
	'UI:History:Changes+' => 'Изменения, внесенные в объект',
	'UI:History:Date' => 'Дата',
	'UI:History:Date+' => 'Дата изменения',
	'UI:History:LastModified_On_By' => 'Последнее изменение %1$s by %2$s.',
	'UI:History:StatsCreations' => 'Создан',
	'UI:History:StatsCreations+' => 'Count of objects created',
	'UI:History:StatsDeletes' => 'Удален',
	'UI:History:StatsDeletes+' => 'Count of objects deleted',
	'UI:History:StatsModifs' => 'Изменен',
	'UI:History:StatsModifs+' => 'Count of objects modified',
	'UI:History:User' => 'Пользователь',
	'UI:History:User+' => 'Пользователь сделавший изменение',
	'UI:HistoryTab' => 'История',
	'UI:ImportDashBoard' => 'Импорт',
	'UI:ImportDashboardText' => 'Выберите файл дашборда для импорта:',
	'UI:ImportDashboardTitle' => 'Импорт из файла',
	'UI:IncidentMgmtMenuOverview:Title' => 'Панель управления инцидентами',
	'UI:InputFile:NoFileSelected' => 'Файл не выбран',
	'UI:InputFile:SelectFile' => 'Выбрать файл',
	'UI:Label:AvailableObjects' => 'Доступные объекты: ',
	'UI:Label:SelectedObjects' => 'Выбранные объекты: ',
	'UI:Link_Class_Attributes' => '%1$s атрибуты',
	'UI:LinksWidget:Autocomplete+' => 'Введите первые 3 символа...',
	'UI:ListConfigurationTitle' => 'Настройка списка',
	'UI:Loading' => 'Загрузка...',
	'UI:LogOff:ClickHereToLoginAgain' => 'Нажмите здесь, чтобы снова войти...',
	'UI:LogOff:ThankYou' => 'Спасибо за использование '.ITOP_APPLICATION_SHORT,
	'UI:LogOffMenu' => 'Выход',
	'UI:LoggedAsMessage' => 'Вы вошли как %1$s (%2$s)',
	'UI:LoggedAsMessage+Admin' => 'Вы вошли как %1$s (%2$s, Администратор)',
	'UI:Login:About' => '',
	'UI:Login:ChangeYourPassword' => 'Изменение пароля',
	'UI:Login:Error:AccessAdmin' => 'Доступ ограничен для лиц с административными привилегиями. Пожалуйста, свяжитесь с администратором '.ITOP_APPLICATION_SHORT.'.',
	'UI:Login:Error:AccessRestricted' => 'Доступ к '.ITOP_APPLICATION_SHORT.' ограничен. Пожалуйста, свяжитесь с администратором '.ITOP_APPLICATION_SHORT.'.',
	'UI:Login:Error:MultipleContactsHaveSameEmail' => 'Несколько контактов имеют один и тот же адрес электронной почты',
	'UI:Login:Error:NoValidProfiles' => 'Нет допустимого профиля',
	'UI:Login:Error:WrongOrganizationName' => 'Неизвестная организация',
	'UI:Login:ForgotPwd' => 'Забыли пароль?',
	'UI:Login:ForgotPwdForm' => 'Восстановление пароля',
	'UI:Login:ForgotPwdForm+' => 'Введите свой логин для входа в систему и нажмите "Отправить". '.ITOP_APPLICATION_SHORT.' отправит email с инструкциями по восстановлению пароля на ваш электронный адрес.',
	'UI:Login:IdentifyYourself' => 'Пожалуйста, представьтесь',
	'UI:Login:IncorrectLoginPassword' => 'Неправильный логин/пароль. Пожалуйста, попробуйте еще раз.',
	'UI:Login:IncorrectOldPassword' => 'Ошибка: старый пароль неверный',
	'UI:Login:NewPasswordPrompt' => 'Новый пароль',
	'UI:Login:OldPasswordPrompt' => 'Старый пароль',
	'UI:Login:PasswordChanged' => 'Пароль успешно изменён!',
	'UI:Login:PasswordNotChanged' => 'Error: Password is the same!~~',
	'UI:Login:PasswordPrompt' => 'Пароль',
	'UI:Login:ResetPassword' => 'Отправить',
	'UI:Login:ResetPwdFailed' => 'Не удалось отправить email: %1$s',
	'UI:Login:RetypeNewPasswordPrompt' => 'Повторите новый пароль',
	'UI:Login:RetypePwdDoesNotMatch' => 'Пароли не совпадают',
	'UI:Login:SeparatorOr' => 'или',
	'UI:Login:Title' => 'Вход в '.ITOP_APPLICATION_SHORT,
	'UI:Login:UserNamePrompt' => 'Имя пользователя',
	'UI:Login:Welcome' => 'Добро пожаловать в '.ITOP_APPLICATION_SHORT.'!',
	'UI:LoginAgain' => 'Войти снова',
	'UI:ManageObjectsOf_Class_LinkedWith_Class_Instance' => 'Управление %1$s объектами связанными с %2$s: %3$s',
	'UI:Menu:Actions' => 'Действия',
	'UI:Menu:Add' => 'Добавить...',
	'UI:Menu:AddToDashboard' => 'Добавить на дашборд...',
	'UI:Menu:BulkDelete' => 'Удалить...',
	'UI:Menu:BulkDelete_Class' => 'Delete %1$s objects...~~',
	'UI:Menu:BulkDelete_Link' => 'Delete %1$s...~~',
	'UI:Menu:BulkDelete_Remote' => 'Delete %1$s...~~',
	'UI:Menu:CSVExport' => 'Экспорт в CSV...',
	'UI:Menu:Delete' => 'Удалить...',
	'UI:Menu:EMail' => 'Отправить ссылку по email',
	'UI:Menu:ExportPDF' => 'Экспорт в PDF...',
	'UI:Menu:FilterList' => 'Display list with search criteria~~',
	'UI:Menu:KillConcurrentLock' => 'Снять блокировку одноврем. измен.!',
	'UI:Menu:Manage' => 'Управление...',
	'UI:Menu:Modify' => 'Редактировать...',
	'UI:Menu:ModifyAll' => 'Редактировать...',
	'UI:Menu:ModifyAll_Class' => 'Modify %1$s objects...~~',
	'UI:Menu:ModifyAll_Link' => 'Modify %1$s...~~',
	'UI:Menu:ModifyAll_Remote' => 'Modify %1$s...~~',
	'UI:Menu:New' => 'Создать...',
	'UI:Menu:OtherActions' => 'Другие действия',
	'UI:Menu:OtherTransitions' => 'Другие переходы',
	'UI:Menu:PrintableVersion' => 'Версия для печати',
	'UI:Menu:ShortcutList' => 'Добавить в избранное...',
	'UI:Menu:Transitions' => 'Переходы',
	'UI:Menu:View' => 'View this object~~',
	'UI:Message:EmptyList:UseAdd' => 'Список пуст, используйте кнопку "Добавить ..." для добавления новых элементов.',
	'UI:Message:EmptyList:UseSearchForm' => 'Используйте форму поиска выше для поиска объектов, которые будут добавлены.',
	'UI:ModificationPageTitle_Object_Class' => ITOP_APPLICATION_SHORT.' - Изменение объекта %2$s - %1$s',
	'UI:ModificationTitle_Class_Object' => 'Изменение объекта %1$s: <span class=\"hilite\">%2$s</span>',
	'UI:ModifiedObject' => 'Объект изменен',
	'UI:ModifyAllPageTitle' => 'Пакетное редактирование',
	'UI:Modify_M_ObjectsOf_Class_OutOf_N' => 'Редактирование %1$d объектов класса %2$s из %3$d',
	'UI:Modify_N_ObjectsOf_Class' => 'Редактирование %1$d объектов класса %2$s',
	'UI:Modify_ObjectsOf_Class' => 'Modifying objects of class %1$s~~',
	'UI:NavigateAwayConfirmationMessage' => 'Все изменения будут отменены.',
	'UI:Newsroom:ConfigurationLink' => 'Конфигурация',
	'UI:Newsroom:DisplayAtMost_X_Messages' => 'Отобразите не более %1$s сообщений в меню %2$s.',
	'UI:Newsroom:DisplayMessagesFor_Provider' => 'Показать сообщения от %1$s',
	'UI:Newsroom:MarkAllAsRead' => 'Отметить все как прочитанные',
	'UI:Newsroom:NoNewMessage' => 'Нет новых сообщений',
	'UI:Newsroom:Preferences' => 'Центр новостей',
	'UI:Newsroom:Priority:1:Tooltip' => 'Critical~~',
	'UI:Newsroom:Priority:2:Tooltip' => 'Urgent~~',
	'UI:Newsroom:Priority:3:Tooltip' => 'Important~~',
	'UI:Newsroom:Priority:4:Tooltip' => 'Normal~~',
	'UI:Newsroom:ResetCache' => 'Сбросить кеш',
	'UI:Newsroom:ResetCache:Success:Message' => 'Your newsroom cache has been successfully reset~~',
	'UI:Newsroom:ViewAllMessages' => 'Посмотреть все сообщения',
	'UI:Newsroom:XNewMessage' => 'Новые сообщения (%1$s)',
	'UI:NoInlineImage' => 'На сервере нет доступных изображений. С помощью кнопки "Обзор..." выше выберите изображение на вашем компьютере, чтобы загрузить его на сервер.',
	'UI:NoObjectToDisplay' => 'Нет объектов для отображения.',
	'UI:NoObject_Class_ToDisplay' => 'Нечего отображать %1$s',
	'UI:NotificationsMenu:Actions' => 'Действия',
	'UI:NotificationsMenu:Actions:Action' => 'Other actions~~',
	'UI:NotificationsMenu:Actions:ActionEmail' => 'Email actions~~',
	'UI:NotificationsMenu:Actions:ActionWebhook' => 'Webhook actions (outgoing integrations)~~',
	'UI:NotificationsMenu:AvailableActions' => 'Доступные действия',
	'UI:NotificationsMenu:AvailableTriggers' => 'Доступные триггеры',
	'UI:NotificationsMenu:Help' => 'Помощь',
	'UI:NotificationsMenu:HelpContent' => '<p>В '.ITOP_APPLICATION_SHORT.' полностью настраиваемые уведомления, которые основаны на двух наборах объектов: <i>триггерах и действиях</i>.</p>
<p><i><b>Триггеры</b></i> определяют, когда необходимо выполнить действия. Базовые триггеры доступны как часть ядра '.ITOP_APPLICATION_SHORT.', другие триггеры добавляются дополнительными расширениями:
<ol>
	<li>триггеры на создание/обновление/удаление объекта срабатывают при <b>создании</b>, <b>обновлении</b> или <b>удалении</b> объекта целевого класса;</li>
	<li>триггеры на изменение статуса срабатывают, когда объект целевого класса <b>входит</b> или <b>выходит</b> из указанного <b>статуса</b>;</li>
	<li>триггеры на пороговое значение срабатывают при <b>достижении порога</b> указанным секундомером <b>TTO</b> или <b>TTR</b>.</li>
</ol>
</p>
<p>
<i><b>Действия</b></i> define the actions to be performed when the triggers execute. For now there are only two kind of actions:
<ol>
	<li>Sending an email message: Such actions also define the template to be used for sending the email as well as the other parameters of the message like the recipients, importance, etc.<br />
	Для тестирования и устранения неполадок в настройках почты доступна специальная страница: <a href="../setup/email.test.php" target="_blank">email.test.php</a>.</li>
	<li>Sending a newsroom message: Display a news to user directly in the application through the newsroom (bell icon on the left menu)</li>
	<li>Outgoing webhooks: Allow integration with a third-party application by sending structured data to a defined URL.</li>
</ol>
</p>
<p>Для выполнения действия связываются с триггерами. При связывании с триггером каждому действию присваивается порядковый номер, который указывает на очерёдность выполнения действий при срабатывании триггера.</p>',
	'UI:NotificationsMenu:OnCreate' => 'При создании объекта',
	'UI:NotificationsMenu:OnStateEnter' => 'При входе объекта в заданное состояние',
	'UI:NotificationsMenu:OnStateLeave' => 'При выходе объекта из заданного состояния',
	'UI:NotificationsMenu:Title' => 'Настройка Уведомлений',
	'UI:NotificationsMenu:Triggers' => 'Триггеры',
	'UI:NotificationsTab' => 'Оповещения',
	'UI:OQL:UnknownClassAndFix' => 'Unknown class "%1$s". You may try "%2$s" instead.~~',
	'UI:OQL:UnknownClassNoFix' => 'Unknown class "%1$s"~~',
	'UI:OQLQueryBuilderTitle' => 'Конструктор запросов OQL',
	'UI:OQLQueryTab' => 'Запрос OQL',
	'UI:ObjectArchived' => 'Этот объект заархивирован. Включите режим просмотра архива или обратитесь к администратору.',
	'UI:ObjectCouldNotBeWritten' => 'Объект не может быть записан: %1$s',
	'UI:ObjectDoesNotExist' => 'Извините, этот объект не существует (или вы не можете его видеть).',
	'UI:ObjectShortcutInsert' => 'Insert Object Shortcut~~',
	'UI:OnlyForThisList' => 'Только для текущего списка',
	'UI:OpenDocumentInNewWindow_' => 'Открыть',
	'UI:OperationCancelled' => 'Операция отменена',
	'UI:OrderByHint_Values' => 'Sort order: %1$s~~',
	'UI:PageFormat_A3' => 'A3',
	'UI:PageFormat_A4' => 'A4',
	'UI:PageFormat_Letter' => 'Letter',
	'UI:PageOrientation_Landscape' => 'Альбомная',
	'UI:PageOrientation_Portrait' => 'Портретная',
	'UI:PageTitle:FatalError' => ITOP_APPLICATION_SHORT.' - Критическая ошибка',
	'UI:PageTitle:ObjectCreated' => ITOP_APPLICATION_SHORT.' Объект создан.',
	'UI:PageTitle:ProfileProjections' => ITOP_APPLICATION_SHORT.' управление пользователями - проектирование профилей',
	'UI:Pagination:All' => 'Все',
	'UI:Pagination:HeaderNoSelection' => 'Всего: %1$s элементов',
	'UI:Pagination:HeaderSelection' => 'Всего: %1$s элементов (%2$s элементов выделено).',
	'UI:Pagination:PageSize' => '%1$s объектов на страницу',
	'UI:Pagination:PagesLabel' => 'Страницы:',
	'UI:PasswordConfirm' => 'Подтвердить',
	'UI:Preferences' => 'Предпочтения',
	'UI:PrintResolution:A4Landscape' => 'A4 – альбомная раскладка',
	'UI:PrintResolution:A4Portrait' => 'A4 – книжная раскладка',
	'UI:PrintResolution:FullSize' => 'Формат',
	'UI:PrintResolution:LetterLandscape' => 'US Letter – альбомная раскладка',
	'UI:PrintResolution:LetterPortrait' => 'US Letter – книжная раскладка',
	'UI:PropertiesTab' => 'Свойства',
	'UI:Query:UrlForExcel' => 'URL-адрес для использования в веб-запросах MS-Excel',
	'UI:Query:UrlV1' => 'Список полей был оставлен неопределенным. Страница <em>export-V2.php</em> не может быть вызван без этой информации. Поэтому URL-адрес, предложенный здесь ниже, указывает на устаревшую страницу: <em>export.php</ем>. Эта устаревшая версия экспорта имеет следующее ограничение: список экспортируемых полей может варьироваться в зависимости от формата вывода и модели данных '.ITOP_APPLICATION_SHORT.'. Если вы хотите гарантировать, что список экспортируемых столбцов будет оставаться стабильным в долгосрочной перспективе, то вы должны указать значение атрибута "Экспорт. поля" и использовать страницу <em>export-V2.php</ем>.',
	'UI:Relation:AdditionalContextInfo' => 'Дополнительная контекстная информация',
	'UI:Relation:AttachmentExportOptions_Name' => 'Параметры вложения к %1$s',
	'UI:Relation:Comments' => 'Comments~~',
	'UI:Relation:DrillDown' => 'Подробнее...',
	'UI:Relation:ExportAsAttachment' => 'Экспорт во Вложения...',
	'UI:Relation:ExportAsPDF' => 'Экспорт в PDF...',
	'UI:Relation:Key' => 'Key~~',
	'UI:Relation:NoneSelected' => 'None~~',
	'UI:Relation:PDFExportOptions' => 'Параметры экспорта в PDF',
	'UI:Relation:PDFExportPageFormat' => 'Формат страницы',
	'UI:Relation:PDFExportPageOrientation' => 'Ориентация страницы',
	'UI:Relation:Zoom' => 'Масштаб',
	'UI:RelationGroupNumber_N' => 'Группа #%1$d',
	'UI:RelationGroups' => 'Группы',
	'UI:RelationOption:Comments' => 'Комментарии',
	'UI:RelationOption:GroupingThreshold' => 'Порог группировки',
	'UI:RelationOption:IncludeList' => 'Включить перечень объектов',
	'UI:RelationOption:Title' => 'Заголовок',
	'UI:RelationOption:Untitled' => 'Untitled~~',
	'UI:RelationTooltip:CriticalThreshold_N_of_M' => 'Критический порог: %1$d / %2$d',
	'UI:RelationTooltip:ImpactedItems_N_of_M' => 'Кол-во затронутых элементов: %1$d / %2$d',
	'UI:RelationTooltip:Redundancy' => 'Избыточность',
	'UI:RelationshipGraph' => 'Графический вид',
	'UI:RelationshipList' => 'Список',
	'UI:RemoveLinkedObjectsOf_Class' => 'Удалить выбранные объекты',
	'UI:RequestMgmtMenuOverview:Title' => 'Панель управления запросами',
	'UI:ResetPwd-EmailBody' => '<body><p>Вы запросили восстановление пароля '.ITOP_APPLICATION_SHORT.'.</p><p>Пожалуйста, воспользуйтесь <a href="%1$s">этой ссылкой</a> для задания нового пароля.</p></body>',
	'UI:ResetPwd-EmailSent' => 'Please check your email box and follow the instructions. If you receive no email, please check the login you typed.~~',
	'UI:ResetPwd-EmailSubject' => 'Восстановление пароля',
	'UI:ResetPwd-Error-EnterPassword' => 'Введите новый пароль для учетной записи пользователя \'%1$s\'.',
	'UI:ResetPwd-Error-FixedPwd' => 'восстановление пароля для данной учётной записи недоступно. Пожалуйста, обратитесь к администратору.',
	'UI:ResetPwd-Error-InvalidToken' => 'Извините, недействительная ссылка. Если вы запрашивали восстановление пароля несколько раз подряд, пожалуйста, убедитесь, что используете ссылку из последнего полученного письма.',
	'UI:ResetPwd-Error-NoContact' => 'данная учетная запись не ассоциирована с персоной. Пожалуйста, обратитесь к администратору.',
	'UI:ResetPwd-Error-NoEmail' => 'отсутствует адрес электронной почты. Пожалуйста, обратитесь к администратору.',
	'UI:ResetPwd-Error-NoEmailAtt' => 'аккаунт не ассоциирован с персоной, имеющей атрибут электронной почты. Пожалуйста, обратитесь к администратору.',
	'UI:ResetPwd-Error-NotPossible' => 'восстановление пароля для внешних учётных записей недоступно.',
	'UI:ResetPwd-Error-Send' => 'технические проблемы с отправкой электронной почты. Пожалуйста, обратитесь к администратору.',
	'UI:ResetPwd-Error-WrongLogin' => 'учетная запись с логином "%1$s" не найдена.',
	'UI:ResetPwd-Login' => 'Войти...',
	'UI:ResetPwd-Ready' => 'Пароль успешно изменён.',
	'UI:ResetPwd-Title' => 'Восстановление пароля',
	'UI:RunQuery:DevelopedOQL' => 'Подготовленный OQL: ',
	'UI:RunQuery:DevelopedOQLCount' => 'Подготовленный OQL для count: ',
	'UI:RunQuery:DevelopedQuery' => 'Декомпилированный запрос OQL: ',
	'UI:RunQuery:Error' => 'Ошибка при выполнении запроса',
	'UI:RunQuery:ExpressionToEvaluate' => 'Оценка выражения: ',
	'UI:RunQuery:HeaderOQLExpression' => 'Выражение OQL',
	'UI:RunQuery:HeaderOQLExpression+' => 'Запрос в синтаксисе OQL',
	'UI:RunQuery:HeaderPurpose' => 'Цель',
	'UI:RunQuery:HeaderPurpose+' => 'Объяснение запросов',
	'UI:RunQuery:MoreInfo' => 'Подробная информация о запросе: ',
	'UI:RunQuery:QueryArguments' => 'Аргументы запроса',
	'UI:RunQuery:QueryExamples' => 'Примеры запросов',
	'UI:RunQuery:QueryResults' => 'Результаты запроса',
	'UI:RunQuery:ResultSQL' => 'Результирующий SQL: ',
	'UI:RunQuery:ResultSQLCount' => 'Результирующий SQL для count: ',
	'UI:RunQuery:SerializedFilter' => 'Сериализованный фильтр: ',
	'UI:RunQuery:Title' => ITOP_APPLICATION_SHORT.' - Оценка запросов OQL',
	'UI:Schema:AbstractClass' => 'Абстрактный класс: используется для наследования свойств, объекты этого класса не создаются.',
	'UI:Schema:AllClasses' => 'Все классы',
	'UI:Schema:AllowedValues' => 'Допустимые значения',
	'UI:Schema:AllowedValues+' => 'Ограничения на возможные значения для этого атрибута',
	'UI:Schema:Attribute/Filter' => 'Filter~~',
	'UI:Schema:AttributeCode' => 'Код атрибута',
	'UI:Schema:AttributeCode+' => 'Внутренний код атрибута',
	'UI:Schema:Attributes' => 'Атрибуты',
	'UI:Schema:AvailOperators' => 'Доступные операторы',
	'UI:Schema:AvailOperators+' => 'Возможные операторы для этого критерия поиска',
	'UI:Schema:CategoryMenuItem' => 'Категория <b>%1$s</b>',
	'UI:Schema:ChildClasses' => 'Дочерние классы',
	'UI:Schema:ClassFilter' => 'Class:~~',
	'UI:Schema:ClassHierarchyTitle' => 'Иерархия классов',
	'UI:Schema:Class_IsLinkedTo_Class_Via_ClassAndAttribute' => '%1$s связан с %2$s через %3$s::<em>%4$s</em>',
	'UI:Schema:Class_ReferencingClasses_From_By' => '%1$s связан с классом %2$s через поле %3$s',
	'UI:Schema:Columns_Description' => 'Столбцы: <em>%1$s</em>',
	'UI:Schema:DefaultNullValue' => 'Default null : "%1$s"~~',
	'UI:Schema:Default_Description' => 'По умолчанию: "%1$s"',
	'UI:Schema:Description' => 'Описание',
	'UI:Schema:Description+' => 'Описание атрибута',
	'UI:Schema:DisplayLabel' => 'Display:~~',
	'UI:Schema:DisplaySelector/Code' => 'Code~~',
	'UI:Schema:DisplaySelector/Label' => 'Label~~',
	'UI:Schema:DisplaySelector/LabelAndCode' => 'Label and code~~',
	'UI:Schema:Events' => 'Events~~',
	'UI:Schema:Events:Defined' => 'Defined events~~',
	'UI:Schema:Events:Description' => 'Description~~',
	'UI:Schema:Events:Event' => 'Event~~',
	'UI:Schema:Events:Listener' => 'Listener~~',
	'UI:Schema:Events:Listeners' => 'Event listeners~~',
	'UI:Schema:Events:Module' => 'Module~~',
	'UI:Schema:Events:NoEvent' => 'No event defined~~',
	'UI:Schema:Events:NoListener' => 'No event listener~~',
	'UI:Schema:Events:Rank' => 'Rank~~',
	'UI:Schema:ExternalKey_To' => 'Внешний ключ %1$s',
	'UI:Schema:FilterCode' => 'Код фильтра',
	'UI:Schema:FilterCode+' => 'Код критерия поиска',
	'UI:Schema:FilterDescription' => 'Описание',
	'UI:Schema:FilterDescription+' => 'Описание критерия поиска',
	'UI:Schema:Label' => 'Метка',
	'UI:Schema:Label+' => 'Метка атрибута',
	'UI:Schema:LifeCycle' => 'Жизненный цикл',
	'UI:Schema:LifeCycleAttributeMustChange' => 'Необходимо изменить',
	'UI:Schema:LifeCycleAttributeMustPrompt' => 'Пользователю будет предложено изменить значение',
	'UI:Schema:LifeCycleEmptyList' => 'пустой список',
	'UI:Schema:LifeCycleHiddenAttribute' => 'Скрытый',
	'UI:Schema:LifeCycleMandatoryAttribute' => 'Обязательный',
	'UI:Schema:LifeCycleReadOnlyAttribute' => 'Только для чтения',
	'UI:Schema:LifeCycleTransitions' => 'Переходы',
	'UI:Schema:LifeCyleAttributeOptions' => 'Варианты атрибутов',
	'UI:Schema:Links:1-n' => 'Классы, указывающие на %1$s (1:n связи):',
	'UI:Schema:Links:All' => 'График всех связанных классов',
	'UI:Schema:Links:n-n' => 'Классы связаны с %1$s (n:n связи):',
	'UI:Schema:MoreInfo' => 'Подробнее',
	'UI:Schema:MoreInfo+' => 'Более подробная информация о поле, определённом в базе данных',
	'UI:Schema:NoLifeCyle' => 'Не определён жизненный цикл для этих классов.',
	'UI:Schema:NonAbstractClass' => 'Реальный класс: объекты этого класса могут быть созданы.',
	'UI:Schema:NullAllowed' => 'Null разрешён',
	'UI:Schema:NullNotAllowed' => 'Null НЕ разрешён',
	'UI:Schema:Origin' => 'Происхождение',
	'UI:Schema:Origin+' => 'Базовый класс, в котором этот атрибут определен',
	'UI:Schema:ReferencingClasses' => 'Привязки классов',
	'UI:Schema:RelatedClasses' => 'Зависимые классы',
	'UI:Schema:RelationDoesNotPropagate' => '%1$s: не распространяется (%2$d уровней), запрос: %3$s',
	'UI:Schema:RelationDown_Description' => 'Вниз: %1$s',
	'UI:Schema:RelationPropagates' => '%1$s: распространяется на %2$d уровней, запрос: %3$s',
	'UI:Schema:RelationUp_Description' => 'Вверх: %1$s',
	'UI:Schema:Relation_Code_Description' => 'Зависимость <em>%1$s</em> (%2$s)',
	'UI:Schema:Relationships' => 'Отношения',
	'UI:Schema:SearchCriteria' => 'Критерий поиска',
	'UI:Schema:Title' => ITOP_APPLICATION_SHORT.' схема объектов',
	'UI:Schema:TitleForClass' => '%1$s schema~~',
	'UI:Schema:Triggers' => 'Триггеры',
	'UI:Schema:Type' => 'Тип',
	'UI:Schema:Type+' => 'Тип данных атрибута',
	'UI:Search:AddCriteria:List:MostPopular:Title' => 'Популярные',
	'UI:Search:AddCriteria:List:Others:Title' => 'Остальные',
	'UI:Search:AddCriteria:List:RecentlyUsed:Placeholder' => 'Пока нет',
	'UI:Search:AddCriteria:List:RecentlyUsed:Title' => 'Недавние',
	'UI:Search:AutoSubmit:DisabledHint' => 'Автоматический запуск поиска отключен для данного класса',
	'UI:Search:Count_ObjectsOf_Class_Found' => '%1$d объект(ов) класса %2$s найдено.',
	'UI:Search:Criteria:DateTime:From' => 'С',
	'UI:Search:Criteria:DateTime:FromTime' => 'С',
	'UI:Search:Criteria:DateTime:PlaceholderFrom' => 'Любая дата',
	'UI:Search:Criteria:DateTime:PlaceholderFromTime' => 'Любая дата',
	'UI:Search:Criteria:DateTime:PlaceholderUntil' => 'Любая дата',
	'UI:Search:Criteria:DateTime:PlaceholderUntilTime' => 'Любая дата',
	'UI:Search:Criteria:DateTime:Until' => 'По',
	'UI:Search:Criteria:DateTime:UntilTime' => 'По',
	'UI:Search:Criteria:HierarchicalKey:ChildrenIncluded:Hint' => 'Включаются все нижестоящие объекты.',
	'UI:Search:Criteria:Locked' => 'Заблокирован',
	'UI:Search:Criteria:Numeric:From' => 'С',
	'UI:Search:Criteria:Numeric:PlaceholderFrom' => 'Любой',
	'UI:Search:Criteria:Numeric:PlaceholderUntil' => 'Любой',
	'UI:Search:Criteria:Numeric:Until' => 'По',
	'UI:Search:Criteria:Operator:Default:Between' => 'Между',
	'UI:Search:Criteria:Operator:Default:Empty' => 'Пусто',
	'UI:Search:Criteria:Operator:Default:Equals' => 'Равно',
	'UI:Search:Criteria:Operator:Default:NotEmpty' => 'Не пусто',
	'UI:Search:Criteria:Operator:Numeric:Different' => 'Не равно',
	'UI:Search:Criteria:Operator:Numeric:Equals' => 'Равно',
	'UI:Search:Criteria:Operator:Numeric:GreaterThan' => 'Больше',
	'UI:Search:Criteria:Operator:Numeric:GreaterThanOrEquals' => 'Больше / равно',
	'UI:Search:Criteria:Operator:Numeric:LessThan' => 'Меньше',
	'UI:Search:Criteria:Operator:Numeric:LessThanOrEquals' => 'Меньше / равно',
	'UI:Search:Criteria:Operator:String:Contains' => 'Содержит',
	'UI:Search:Criteria:Operator:String:EndsWith' => 'Заканч. на',
	'UI:Search:Criteria:Operator:String:RegExp' => 'Регуляр. выраж.',
	'UI:Search:Criteria:Operator:String:StartsWith' => 'Начинается с',
	'UI:Search:Criteria:Operator:TagSet:Matches' => 'Совпадает',
	'UI:Search:Criteria:Raw:Filtered' => 'Отфильтровано',
	'UI:Search:Criteria:Raw:FilteredOn' => 'Отфильтровано по %1$s',
	'UI:Search:Criteria:Remove' => 'Удалить',
	'UI:Search:Criteria:Title:DateTime:Between' => '%2$s <= 1$s <= %3$s',
	'UI:Search:Criteria:Title:Default:Any' => '%1$s: все',
	'UI:Search:Criteria:Title:Default:Between' => '%1$s между [%2$s]',
	'UI:Search:Criteria:Title:Default:Between:All' => '%1$s: все',
	'UI:Search:Criteria:Title:Default:Between:From' => '%1$s от %2$s',
	'UI:Search:Criteria:Title:Default:Between:Until' => '%1$s до %2$s',
	'UI:Search:Criteria:Title:Default:BetweenDates' => '%1$s [%2$s]',
	'UI:Search:Criteria:Title:Default:BetweenDates:All' => '%1$s: все',
	'UI:Search:Criteria:Title:Default:BetweenDates:From' => '%1$s с %2$s',
	'UI:Search:Criteria:Title:Default:BetweenDates:Until' => '%1$s по %2$s',
	'UI:Search:Criteria:Title:Default:Contains' => '%1$s содержит %2$s',
	'UI:Search:Criteria:Title:Default:Different' => '%1$s ≠ %2$s',
	'UI:Search:Criteria:Title:Default:Empty' => '%1$s пусто',
	'UI:Search:Criteria:Title:Default:EndsWith' => '%1$s заканчивается на %2$s',
	'UI:Search:Criteria:Title:Default:Equals' => '%1$s равно %2$s',
	'UI:Search:Criteria:Title:Default:GreaterThan' => '%1$s > %2$s',
	'UI:Search:Criteria:Title:Default:GreaterThanOrEquals' => '%1$s >= %2$s',
	'UI:Search:Criteria:Title:Default:LessThan' => '%1$s < %2$s',
	'UI:Search:Criteria:Title:Default:LessThanOrEquals' => '%1$s <= %2$s',
	'UI:Search:Criteria:Title:Default:NotEmpty' => '%1$s не пусто',
	'UI:Search:Criteria:Title:Default:RegExp' => '%1$s соответствует %2$s',
	'UI:Search:Criteria:Title:Default:StartsWith' => '%1$s начинается с %2$s',
	'UI:Search:Criteria:Title:Enum:In' => '%1$s: %2$s',
	'UI:Search:Criteria:Title:Enum:In:All' => '%1$s: все',
	'UI:Search:Criteria:Title:Enum:In:Many' => '%1$s: %2$s и %3$s других',
	'UI:Search:Criteria:Title:ExternalKey:Empty' => '%1$s определён',
	'UI:Search:Criteria:Title:ExternalKey:Equals' => '%1$s %2$s',
	'UI:Search:Criteria:Title:ExternalKey:In' => '%1$s: %2$s',
	'UI:Search:Criteria:Title:ExternalKey:In:All' => '%1$s: все',
	'UI:Search:Criteria:Title:ExternalKey:In:Many' => '%1$s: %2$s и %3$s других',
	'UI:Search:Criteria:Title:ExternalKey:NotEmpty' => '%1$s не определён',
	'UI:Search:Criteria:Title:HierarchicalKey:Empty' => '%1$s определён',
	'UI:Search:Criteria:Title:HierarchicalKey:Equals' => '%1$s %2$s',
	'UI:Search:Criteria:Title:HierarchicalKey:In' => '%1$s: %2$s',
	'UI:Search:Criteria:Title:HierarchicalKey:In:All' => '%1$s: все',
	'UI:Search:Criteria:Title:HierarchicalKey:In:Many' => '%1$s: %2$s и %3$s других',
	'UI:Search:Criteria:Title:HierarchicalKey:NotEmpty' => '%1$s не определён',
	'UI:Search:Criteria:Title:TagSet:Matches' => '%1$s: %2$s',
	'UI:Search:Criteria:Toggle' => 'Развернуть / Свернуть',
	'UI:Search:Criterion:MoreMenu:AddCriteria' => 'Добавить критерий',
	'UI:Search:Enlarge' => 'Расширить поиск',
	'UI:Search:NeedleTooShort' => 'Строка поиска "%1$s" слишком короткая. Введите не менее %2$d символов.',
	'UI:Search:NoAutoSubmit:ExplainText' => 'Добавьте критерии поиска или нажмите кнопку поиска, чтобы просмотреть объекты.',
	'UI:Search:NoObjectFound' => 'Объекты не найдены.',
	'UI:Search:NoSearch' => 'Ничего не найдено',
	'UI:Search:Obsolescence:DisabledHint' => 'Устаревшие данные скрыты в соответствии с вашими предпочтениями',
	'UI:Search:Ongoing' => 'Поиск "%1$s"',
	'UI:Search:Toggle' => 'Развернуть / Свернуть',
	'UI:Search:Value:Autocomplete:NoResult' => 'Нет результата.',
	'UI:Search:Value:Autocomplete:StartTyping' => 'Начните печатать, чтобы увидеть возможные значения.',
	'UI:Search:Value:Autocomplete:Wait' => 'Пожалуйста, подождите...',
	'UI:Search:Value:Filter:Placeholder' => 'Фильтр...',
	'UI:Search:Value:Search:Placeholder' => 'Поиск...',
	'UI:Search:Value:Toggler:CheckAllNone' => 'Отметить / снять все',
	'UI:Search:Value:Toggler:CheckAllNoneFiltered' => 'Отметить / снять все видимые',
	'UI:SearchFor_Class' => 'Поиск: %1$s',
	'UI:SearchFor_Class_Objects' => 'Поиск: %1$s',
	'UI:SearchResultsPageTitle' => ITOP_APPLICATION_SHORT.' - Результаты поиска',
	'UI:SearchResultsTitle' => 'Результаты поиска',
	'UI:SearchResultsTitle+' => 'Результаты полнотекстового поиска',
	'UI:SearchToggle' => 'Поиск',
	'UI:SearchValue:Any' => '* Любой *',
	'UI:SearchValue:CheckAll' => 'Выбрать все',
	'UI:SearchValue:Mixed' => '* смешанный *',
	'UI:SearchValue:NbSelected' => '# выбрано',
	'UI:SearchValue:UncheckAll' => 'Сбросить',
	'UI:SelectAllToggle+' => 'Выбрать всё / Отменить всё',
	'UI:SelectInlineImageToUpload' => 'Выберите изображение для загрузки',
	'UI:SelectOne' => '-- выбрать --',
	'UI:SelectTheTypeOf_Class_ToCreate' => 'Выбор типа %1$s для создания:',
	'UI:SelectionOf_Class' => 'Выбор объектов класса %1$s',
	'UI:ServiceMgmtMenuOverview:Title' => 'Панель управления услугами',
	'UI:ShortcutDelete:Confirm' => 'Подтвердите удаление ссылки (ссылок).',
	'UI:ShortcutListDlg:Title' => 'Добавить в избранное ссылку на список',
	'UI:ShortcutRenameDlg:Title' => 'Переименовать ссылку',
	'UI:SimpleSearchTab' => 'Простой поиск',
	'UI:SplitDateTime-Date' => 'дата',
	'UI:SplitDateTime-Time' => 'время',
	'UI:StateChanged' => 'State changed~~',
	'UI:StayOnThePage' => 'Остаться на этой странице',
	'UI:StimulusModify_N_ObjectsOf_Class' => '%1$s: Modifying %2$d objects of class %3$s~~',
	'UI:SystemIntrusion' => 'Доступ запрещён. Вы пытаетесь выполнить неразрешённую операцию.',
	'UI:TagAdminMenu:NoTags' => 'Не настроены поля тегов',
	'UI:TagAdminMenu:Title' => 'Настройка тегов',
	'UI:TagSetFieldData:Error' => 'Ошибка: %1$s',
	'UI:Title:BulkDeletionOf_Count_ObjectsOf_Class' => 'Пакетное удаление %1$d объектов класса %2$s',
	'UI:Title:BulkImport' => ITOP_APPLICATION_SHORT.' - Пакетный импорт',
	'UI:Title:BulkImport+' => 'Мастер импорта CSV',
	'UI:Title:BulkSynchro_nbItem_ofClass_class' => 'Synchronization of %1$d objects of class %2$s~~',
	'UI:Title:CSVImportStep2' => 'Шаг 2 из 5: Опции данных CSV',
	'UI:Title:CSVImportStep3' => 'Шаг 3 из 5: Распределение данных',
	'UI:Title:CSVImportStep4' => 'Шаг 4 из 5: Симуляция импорта',
	'UI:Title:CSVImportStep5' => 'Шаг 5 из 5: Импорт завершён',
	'UI:Title:DataPreview' => 'Предпросмотр данных',
	'UI:Title:DeletionOf_Object' => 'Удаление %1$s',
	'UI:Title:Object_Of_Class_Created' => '%1$s - %2$s создан.',
	'UI:Toggle:CustomDashboard' => 'Пользовательский',
	'UI:Toggle:StandardDashboard' => 'Стандартный',
	'UI:Toggle:SwitchToCustomDashboard' => 'Переключить на пользовательский дашборд',
	'UI:Toggle:SwitchToStandardDashboard' => 'Переключить на стандартный дашборд',
	'UI:ToggleFullScreen' => 'Развернуть / Свернуть',
	'UI:Treeview:CollapseAll' => 'Свернуть все',
	'UI:Treeview:ExpandAll' => 'Развернуть все',
	'UI:TruncatedResults' => '%1$d объектов отображено из %2$d',
	'UI:UndefinedObject' => 'неопределённый',
	'UI:UniversalSearch:Error' => 'Ошибка: %1$s',
	'UI:UniversalSearch:LabelSelectTheClass' => 'Выбор класса для поиска: ',
	'UI:UniversalSearchTitle' => ITOP_APPLICATION_SHORT.' - Универсальный поиск',
	'UI:UploadInlineImageLegend' => 'Загрузить новое изображение',
	'UI:UploadNotSupportedInThisMode' => 'Изменение изображений и файлов не поддерживается в этом режиме.',
	'UI:UseDefaultSettings' => 'Использовать настройки по умолчанию',
	'UI:UseSavetheSettings' => 'Сохранить настройки',
	'UI:UseSpecificSettings' => 'Использовать эти настройки:',
	'UI:UserManagement:Action' => 'Действие',
	'UI:UserManagement:Action+' => 'Действие, выполняемое пользователем',
	'UI:UserManagement:Action:BulkDelete' => 'Пакетное удаление',
	'UI:UserManagement:Action:BulkDelete+' => 'Массовое удаление объектов',
	'UI:UserManagement:Action:BulkModify' => 'Пакетное изменение',
	'UI:UserManagement:Action:BulkModify+' => 'Массовое создание/редактирование (импорт CSV)',
	'UI:UserManagement:Action:BulkRead' => 'Пакетное чтение (Экспорт)',
	'UI:UserManagement:Action:BulkRead+' => 'Список объектов или массовый экспорт',
	'UI:UserManagement:Action:Delete' => 'Удаление',
	'UI:UserManagement:Action:Delete+' => 'Удаление объектов',
	'UI:UserManagement:Action:Modify' => 'Изменение',
	'UI:UserManagement:Action:Modify+' => 'Создание и редактирование (изменение) объектов',
	'UI:UserManagement:Action:Read' => 'Чтение',
	'UI:UserManagement:Action:Read+' => 'Чтение/отображение объектов',
	'UI:UserManagement:Action:Stimuli' => 'Стимулы',
	'UI:UserManagement:Action:Stimuli+' => 'Разрешенные действия',
	'UI:UserManagement:ActionAllowed:No' => 'Нет',
	'UI:UserManagement:ActionAllowed:Yes' => 'Да',
	'UI:UserManagement:AdminProfile+' => 'Администраторы имеют полный доступ на чтение/запись всех объектов в базе данных.',
	'UI:UserManagement:AnyObject' => '* любой *',
	'UI:UserManagement:Attributes' => 'Атрибуты',
	'UI:UserManagement:Class' => 'Класс',
	'UI:UserManagement:Class+' => 'Класс объектов',
	'UI:UserManagement:GrantMatrix' => 'Матрица разрешений',
	'UI:UserManagement:NoLifeCycleApplicable' => 'не определено',
	'UI:UserManagement:NoLifeCycleApplicable+' => 'Не определён жизненный цикл для данного класса',
	'UI:UserManagement:Permission' => 'Разрешения',
	'UI:UserManagement:Permission+' => 'Пользовательские разрешения',
	'UI:UserManagement:ProjectedObject' => 'Объект',
	'UI:UserManagement:ProjectedObject+' => 'Проектируемый объект',
	'UI:UserManagement:TitleActions' => 'Действия',
	'UI:UserManagement:User' => 'Пользователь',
	'UI:UserManagement:User+' => '',
	'UI:UserPref:DoNotShowAgain' => 'Больше не показывать',
	'UI:ValueInvalidFormat' => 'Недопустимый формат',
	'UI:ValueMustBeChanged' => 'Пожалуйста, измените значение',
	'UI:ValueMustBeSet' => 'Пожалуйста, укажите значение',
	'UI:WelcomeMenu:AllConfigItems' => 'Конфигурационные единицы: %1$d',
	'UI:WelcomeMenu:AllOpenRequests' => 'Открытые запросы: %1$d',
	'UI:WelcomeMenu:MyCalls' => 'Мои запросы',
	'UI:WelcomeMenu:MyIncidents' => 'Инциденты назначенные на меня',
	'UI:WelcomeMenu:OpenIncidents' => 'Открытые инциденты: %1$d',
	'UI:WelcomeMenu:Title' => 'Добро пожаловать в '.ITOP_APPLICATION_SHORT,
	'UI:WelcomeToITop' => 'Добро пожаловать в '.ITOP_APPLICATION_SHORT,
	'UI:Wizard:FinalStepTitle' => 'Последний шаг: подтверждение',
	'UI:YourSearch' => 'Поиск',
	'UI:iTopVersion:Long' => '%1$s версия %2$s-%3$s основан на %4$s',
	'UI:iTopVersion:Short' => '%1$s версия %2$s',
	'UI_CountOfObjectsShort' => '%1$d объектов.',
	'portal:backoffice' => ITOP_APPLICATION_SHORT.' Back-Office интерфейс',
	'portal:legacy_portal' => 'Пользовательский портал',
	'Menu:ConfigEditor'           => 'General configuration~~',
	'Menu:ConfigEditor+'          => 'Configuration File editor~~',
	'Menu:Integrations'           => 'Integrations~~',
	'Menu:Integrations+'          => '~~',
]);
